package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.IDGenerator;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 商城:用户优惠券基础信息
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserCouponBasicVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 784844681919535650L;
    // com.liquidnet.service.goblin.entity.GoblinUserCoupon
    private String ucouponId;
    private String storeCouponId;
    private String uid;////
    private Integer state;
    private LocalDateTime bindAt;
    private LocalDateTime duedAt;
    private LocalDateTime usedAt;
    private String usedFor;
    private String operator;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;


    // com.liquidnet.service.goblin.entity.GoblinStoreCoupon
    private String storeId;////
    private String title;
    private String label;
    private String notice;
    private String type;
    private BigDecimal triggers;
    private BigDecimal valFace;
    private BigDecimal discount;
    private BigDecimal valOver;
    private BigDecimal valMinus;
    private BigDecimal deduction;
    private String useScope;

    private static final GoblinUserCouponBasicVo obj = new GoblinUserCouponBasicVo();

    public static GoblinUserCouponBasicVo getNew() {
        try {
            return (GoblinUserCouponBasicVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserCouponBasicVo();
        }
    }

    public GoblinUserCouponBasicVo initByStoreCouponVo(GoblinStoreCouponVo source) {
        if (null == source) return this;
        this.setUcouponId(IDGenerator.get32UUID());
        this.setStoreCouponId(source.getStoreCouponId());
//        this.setUid();
        this.setState(1);
//        this.setBindAt();
        this.setDuedAt(source.getEndTime());
//        this.setUsedAt();
//        this.setUsedFor();
//        this.setOperator();
//        this.setCreatedAt();
//        this.setUpdatedAt();
        this.setStoreId(source.getStoreId());
        this.setTitle(source.getTitle());
        this.setLabel(source.getLabel());
        this.setNotice(source.getNotice());
        this.setType(source.getType());
        this.setTriggers(source.getTriggers());
        this.setValFace(source.getValFace());
        this.setDiscount(source.getDiscount());
        this.setValOver(source.getValOver());
        this.setValMinus(source.getValMinus());
        this.setDeduction(source.getDeduction());
        this.setUseScope(source.getUseScope());
        return this;
    }
}
