package com.liquidnet.service.kylin.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.returns.*;
import com.liquidnet.service.kylin.service.IKylinOrderTicketsService;
import com.liquidnet.service.kylin.service.impl.KylinOrderTicketsServiceImpl;
import io.swagger.annotations.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 订单 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Api(tags = "前端-订单相关")
@RestController
@RequestMapping("order")
@Validated
public class KylinOrderTicketsController {

    @Autowired
    IKylinOrderTicketsService orderTicketsService;

//    @PostMapping("pre")
//    @ApiOperation("下单")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    public ResponseDto<PayResultVo> checkCanOrder(@RequestBody @Valid PayOrderParam payOrderParam) {
//        return orderTicketsService.checkCanOrder(payOrderParam);
//    }
//
//    @PostMapping("payAgain")
//    @ApiOperation("再次支付")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    public ResponseDto<PayResultVo> payAgain(@RequestBody @Valid PayAgainParam payAgainParam) {
//        PayResultVo vo = orderTicketsService.payAgain(payAgainParam).getData();
//        if (null == vo) {
//            return ResponseDto.failure(ErrorMapping.get("20024"));
//        } else {
//            return ResponseDto.success(vo);
//        }
//    }
//
//    @PostMapping("syncOrder")
//    @ApiOperation("支付回调")
//    @ApiResponse(code = 200, message = "接口返回对象参数")
//    public String syncOrder(@ModelAttribute @Valid SyncOrderParam syncOrderParam) {
//        return orderTicketsService.syncOrder(syncOrderParam);
//    }

    @GetMapping("list")
    @ApiOperation("订单列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<KylinOrderListVo>>> orderList() {
        return ResponseDto.success(orderTicketsService.orderList());
    }

    @GetMapping("list/unLimit")
    @ApiOperation("订单列表Mongo")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<KylinOrderListVo>>> orderListMongo(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size) {
        return ResponseDto.success(orderTicketsService.orderListMongo(page, size));
    }

    @GetMapping("details")
    @ApiOperation("订单详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<OrderDetailsVo> orderDetails(@RequestParam(value = "orderId", required = false) @NotNull(message = "订单ID不能为空") String orderId) {
        OrderDetailsVo vo = orderTicketsService.orderDetails(orderId);
        if (null == vo) {
            return ResponseDto.failure(ErrorMapping.get("20003"));
        } else {
            return ResponseDto.success(vo);
        }
    }

    @GetMapping("supplementEnter")
    @ApiOperation("补充入场人")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> supplementEnter(@RequestParam(value = "orderId", required = true) @NotNull(message = "订单ID不能为空") String orderId,
                                                @RequestParam(value = "enterList", required = true) @NotNull(message = "入场人id(逗号隔开)") String enterList) {
        return orderTicketsService.supplementEnter(orderId, enterList);
    }

    @GetMapping("orderUnPayCount")
    @ApiOperation("待支付演出订单数量")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap> orderUnPayCount() {
        Integer unPayCount = orderTicketsService.orderUnPayCount().getData();
        HashMap<String, Integer> map = CollectionUtil.mapStringInteger();
        map.put("unPayCount", unPayCount);
        return ResponseDto.success(map);
    }

    @PostMapping("transfer")
    @ApiOperation("转赠订单")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "transferUid", value = "转赠目标uid"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "transferMobile", value = "转赠目标手机号"),
    })
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> orderTransfer(@RequestParam(value = "orderId") @NotNull @NotBlank String orderId,
                                             @RequestParam(value = "transferUid") @NotNull @NotBlank String transferUid,
                                             @RequestParam(value = "transferMobile") @NotNull @NotBlank String transferMobile
    ) {
        return orderTicketsService.orderTransfer(orderId, transferUid, transferMobile);
    }


    @PostMapping("transferWithDraw")
    @ApiOperation("转赠订单撤回")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
    })
    public ResponseDto<String> orderTransferWithdraw(@RequestParam(value = "orderId") @NotNull @NotBlank String orderId) {
        return orderTicketsService.orderTransferWithdraw(orderId);
    }

    @PostMapping("transferAccept")
    @ApiOperation("转赠订单接收")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "enterIdList", value = "逗号隔开的入场人id"),
    })
    public ResponseDto<String> orderTransferAccept(@RequestParam(required = false) String enterIdList) {
        return orderTicketsService.orderTransferAccept(enterIdList);
    }

    @PostMapping("transferReject")
    @ApiOperation("转赠订单拒收")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> orderTransferReject() {
        return orderTicketsService.orderTransferReject();
    }

    @PostMapping("transferBack")
    @ApiOperation("转赠订单退回")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> orderTransferBack(@RequestParam(value = "orderId") String orderId) {
        return orderTicketsService.orderTransferBack(orderId);
    }

    @GetMapping("toOrderRefundDetails")
    @ApiOperation("想要退款订单详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<KylinOrderTicketPreVo> toOrderRefundDetails(@RequestParam(value = "orderId", required = false) @NotNull(message = "订单ID不能为空") String orderId) {
        return orderTicketsService.toOrderRefundDetails(orderId);
    }

    @PostMapping("sendOrderRefunds")
    @ApiOperation("发起退款申请")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<HashMap<String, String>> sendOrderRefund(@RequestParam(value = "orderId", required = true) @NotNull(message = "订单ID不能为空") String orderId,
                                                                @RequestParam(value = "orderTicketEntitiesId", required = true) @NotNull(message = "票单ID不能为空") String orderTicketEntitiesId,
                                                                @RequestParam(value = "reason", required = true) @NotNull(message = "退款原因不能为空") String reason,
                                                                @RequestParam(value = "picList", required = false) String picList) {
        String orderRefundId = orderTicketsService.sendOrderRefund(orderId, orderTicketEntitiesId, reason, picList);
        if (orderRefundId.length() > 10) {
            HashMap<String, String> map = CollectionUtil.mapStringString();
            map.put("orderRefundsId", orderRefundId);
            return ResponseDto.success(map);
        } else {
            return ResponseDto.failure(orderRefundId);
        }
    }

    @GetMapping("orderRefundDetails")
    @ApiOperation("退款申请详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<OrderRefundVo> orderRefundDetails(@RequestParam(value = "orderId", required = true) @NotNull(message = "订单ID不能为空") String orderId,
                                                         @RequestParam(value = "orderRefundId", required = true) @NotNull(message = "退款订单ID不能为空") String orderRefundId) {
        return orderTicketsService.orderRefundDetails(orderId, orderRefundId);
    }

    @PostMapping("orderRefundWithdraw")
    @ApiOperation("发起退款撤回")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> orderRefundWithdraw(@RequestParam(value = "orderRefundId", required = true) @NotNull(message = "退款订单ID不能为空") String orderRefundId) {
        return orderTicketsService.orderRefundWithdraw(orderRefundId);
    }
}
