package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderDetailedByShowDateExportVo implements Serializable, Cloneable {
    @Excel(name = "订单号", cellType = Excel.ColumnType.STRING)
    private String orderCode;
    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String payCode;
    @Excel(name = "微信/支付宝订单号", cellType = Excel.ColumnType.STRING)
    private String paymentId;
    @Excel(name = "购买名称", cellType = Excel.ColumnType.STRING)
    private String performanceTitle;
    @Excel(name = "支付平台", cellType = Excel.ColumnType.STRING)
    private String paymentType;
    @Excel(name = "演出类型", cellType = Excel.ColumnType.STRING)
    private String type;
    @Excel(name = "票种名称", cellType = Excel.ColumnType.STRING)
    private String title1;
    @Excel(name = "购票数量", cellType = Excel.ColumnType.STRING)
    private String number;
    @Excel(name = "场次", cellType = Excel.ColumnType.STRING)
    private String title2;
    //todo
    @Excel(name = "退款时间", cellType = Excel.ColumnType.STRING)
    private String updateAt;
    @Excel(name = "退款原因", cellType = Excel.ColumnType.STRING)
    private String reject;
    @Excel(name = "支付金额", cellType = Excel.ColumnType.STRING)
    private String priceActual;
    @Excel(name = "支付时间", cellType = Excel.ColumnType.STRING)
    private String timePay;



    private static final OrderDetailedByShowDateExportVo obj = new OrderDetailedByShowDateExportVo();

    public static OrderDetailedByShowDateExportVo getNew() {
        try {
            return (OrderDetailedByShowDateExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderDetailedByShowDateExportVo();
    }

    public OrderDetailedByShowDateExportVo copyOrderExportVo(OrderExportDao source) {
        this.setPerformanceTitle(source.getPerformanceTitle());
        this.setOrderCode(source.getOrderCode());
        this.setPayCode(source.getPayCode());
        this.setPaymentId(source.getPaymentId());
        this.setPaymentType(source.getPaymentType());
        this.setType(source.getType());
        this.setTitle1(source.getTitle1());
        this.setTitle2(source.getTitle2());
        this.setNumber(source.getNumber());
        this.setPriceActual(source.getPriceActual());
        this.setUpdateAt(source.getRefundAt());
        this.setReject(source.getReject());
        this.setTimePay(source.getTimePay());
        return this;
    }



}
