package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class ConsumerCommonSqlRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    ConsumerGoblinSqlStoreRdsReceiver consumerGoblinSqlStoreRdsReceiver;
    @Autowired
    ConsumerGoblinSqlGoodsRdsReceiver consumerGoblinSqlGoodsRdsReceiver;
    @Autowired
    ConsumerGoblinSqlCouponRdsReceiver consumerGoblinSqlCouponRdsReceiver;
    @Autowired
    ConsumerGoblinSqlArtworkGenRdsReceiver consumerGoblinSqlArtworkGenRdsReceiver;
//    @Autowired
//    ConsumerGoblinNftOrderRdsReceiver consumerGoblinNftOrderRdsReceiver;

    @Bean// 店铺相关
    public List<Subscription> subscriptionSqlStore(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.SQL_STORE;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlStoreRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 商品相关
    public List<Subscription> subscriptionSqlGoods(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.SQL_GOODS;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlGoodsRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 店铺优惠券相关
    public List<Subscription> subscriptionSqlStoreCoupon(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.SQL_COUPON;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 1; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlCouponRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

    @Bean// 藏品生成
    public List<Subscription> subscriptionSqlArtworkGen(RedisConnectionFactory factory) {
        List<Subscription> subscriptionList = new ArrayList<>();
        MQConst.GoblinQueue stream = MQConst.GoblinQueue.SQL_ARTWORK_GEN;
        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
        for (int i = 0; i < 5; i++) {
            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
            subscriptionList.add(listenerContainer.receiveAutoAck(
                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlArtworkGenRdsReceiver
            ));
            listenerContainer.start();
        }
        return subscriptionList;
    }

//    @Bean// NFT订单
//    public List<Subscription> subscriptionSqlNftOrder(RedisConnectionFactory factory) {
//        List<Subscription> subscriptionList = new ArrayList<>();
//        MQConst.GoblinQueue stream = MQConst.GoblinQueue.GOBLIN_NFT_ORDER;
//        this.initStream(stringRedisTemplate, stream.getKey(), stream.getGroup());
//        for (int i = 0; i < 15; i++) {
//            StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = this.buildStreamMessageListenerContainer(factory);
//            subscriptionList.add(listenerContainer.receiveAutoAck(
//                    Consumer.from(stream.getGroup(), getConsumerName(stream.name() + i)),
//                    StreamOffset.create(stream.getKey(), ReadOffset.lastConsumed()), consumerGoblinNftOrderRdsReceiver
//            ));
//            listenerContainer.start();
//        }
//        return subscriptionList;
//    }
}
