package com.liquidnet.service.galaxy.router.zxin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyArtwork;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterArtworkHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinArtworkBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterArtworkHandler(GalaxyEnum.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlArtworkImpl implements IGalaxyRouterStrategyArtwork {
    @Autowired
    private ZxinArtworkBiz zxinArtworkBiz;

    @Override
    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        return zxinArtworkBiz.nftImageCheck(reqDto);
    }

    @Override
    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        return zxinArtworkBiz.nftUpload(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        return zxinArtworkBiz.seriesClaim(reqDto);
    }

    @Override
    public ResponseDto<GalaxyArtSeriesClaimResultQueryRespDto> seriesClaimResultQuery(GalaxyArtSeriesClaimResultQueryReqDto reqDto) {
        return zxinArtworkBiz.seriesClaimResultQuery(reqDto);
    }
}
