package com.liquidnet.client.admin.zhengzai.sweet.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.sweet.dto.SweetActivityDrawListDao;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetActivityDrawExcelListDao implements Serializable, Cloneable {

    private static final long serialVersionUID = -3918944925598231439L;

    @Excel(name = "活动id")
    private String integralActivityId;
    @Excel(name = "奖品id")
    private String prizeId;
    @Excel(name = "用户id")
    private String userId;
    @Excel(name = "完整地址")
    private String receivingAddress;
    @Excel(name = "发放状态")
    private Integer receivingStatus;
    @Excel(name = "创建时间")
    private LocalDateTime createdAt;

    private static final SweetActivityDrawExcelListDao obj = new SweetActivityDrawExcelListDao();

    public static SweetActivityDrawExcelListDao getNew() {
        try {
            return (SweetActivityDrawExcelListDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetActivityDrawExcelListDao();
        }
    }

    public SweetActivityDrawExcelListDao copy(SweetActivityDrawListDao source) {
        if (null == source) return this;
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeId(source.getPrizeId());
        this.setUserId(source.getUserId());
        this.setReceivingAddress(source.getReceivingAddress());
        this.setReceivingStatus(source.getReceivingStatus());
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }
}
