package com.liquidnet.client.admin.zhengzai.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SweetRedisAdminUtils {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;

    public void setIntegralActivityList(List<IntegralActivityVo> voList) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_LIST;
        boolean set = redisUtil.set(redisKey, voList);
    }
    public void setIntegralActivityInfo(IntegralActivityVo integralActivityVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_INFO.concat(integralActivityVo.getIntegralActivityId());
        boolean set = redisUtil.set(redisKey, integralActivityVo);
    }

    public void setIntegralActivityPrizeNum(String integralActivityId, SweetIntegralActivityPrize sweetIntegralActivityPrize) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(sweetIntegralActivityPrize.getPrizeId());
        redisUtil.incr(redisKey, sweetIntegralActivityPrize.getPrizeNum());
    }

    public void setIntegralActivityPrizeWinnersNum(String integralActivityId, SweetIntegralActivityPrize sweetIntegralActivityPrize) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_INTEGRAL_ACTIVITY_PRIZE_WINNERS_NUM
                .concat(integralActivityId)
                .concat(":prizeId:")
                .concat(sweetIntegralActivityPrize.getPrizeId());
        redisUtil.incr(redisKey, sweetIntegralActivityPrize.getPrizeNum());
    }
}
