package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.liquidnet.client.admin.common.exception.BusinessException;
import com.liquidnet.client.admin.zhengzai.kylin.dto.*;
import com.liquidnet.client.admin.zhengzai.kylin.service.IExportService;
import com.liquidnet.service.kylin.dao.CommodityOrderExportDao;
import com.liquidnet.service.kylin.dao.MemberOrderExportDao;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class ExportServiceImpl implements IExportService {

    @Autowired
    KylinPerformancesMapper performancesMapper;

    @Override
    public List<OrderExportVo> exportOrderByPerformanceIdAll(String performancesId) {
        List<OrderExportDao> list = performancesMapper.exportOrderByPerformanceIdAll(performancesId);
        List<OrderExportVo> voList = new ArrayList();
        for (OrderExportDao item :list){
            voList.add(OrderExportVo.getNew().copyOrderExportVo(item));
        }
        return voList;
    }

    @Override
    public List<OrderExportVo> exportOrderByPerformanceIdPay(String performancesId) {
        List<OrderExportDao> list = performancesMapper.exportOrderByPerformanceIdPay(performancesId);
        List<OrderExportVo> voList = new ArrayList();
        for (OrderExportDao item :list){
            voList.add(OrderExportVo.getNew().copyOrderExportVo(item));
        }
        return voList;
    }

    @Override
    public List<OrderDetailedExportVo> exportOrderByOrderTime(String beginTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date beginDate = sdf.parse(beginTime);
            Date endDate = sdf.parse(endTime);
            List<OrderExportDao> list = performancesMapper.exportOrderByOrderTime(beginDate,endDate);
            List<OrderDetailedExportVo> voList = new ArrayList();
            for (OrderExportDao item :list){
                voList.add(OrderDetailedExportVo.getNew().copyOrderExportVo(item));
            }
            return voList;
        } catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("导出异常，请联系网站管理员！");
        }
    }

    @Override
    public List<OrderDetailedByShowDateExportVo> exportOrderByShowTime(String beginTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date beginDate = sdf.parse(beginTime);
            Date endDate = sdf.parse(endTime);
            List<OrderExportDao> list = performancesMapper.exportOrderByShowTime(beginDate,endDate);
            List<OrderDetailedByShowDateExportVo> voList = new ArrayList();
            for (OrderExportDao item :list){
                voList.add(OrderDetailedByShowDateExportVo.getNew().copyOrderExportVo(item));
            }
            return voList;
        } catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("导出异常，请联系网站管理员！");
        }
    }

    @Override
    public List<OrderDetailedByShowIdExportVo> exportOrderByShowId(String showId) {
        List<OrderExportDao> list = performancesMapper.exportOrderByShowId(showId);
        List<OrderDetailedByShowIdExportVo> voList = new ArrayList();
        for (OrderExportDao item :list){
            voList.add(OrderDetailedByShowIdExportVo.getNew().copyOrderExportVo(item));
        }
        return voList;
    }

    @Override
    public List<OrderMemberExportVo> exportMemberOrder(String beginTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date beginDate = sdf.parse(beginTime);
            Date endDate = sdf.parse(endTime);
            List<MemberOrderExportDao> list = performancesMapper.exportMemberOrder(beginDate,endDate);
            List<OrderMemberExportVo> voList = new ArrayList();
            for (MemberOrderExportDao item :list){
                voList.add(OrderMemberExportVo.getNew().copyMemberOrderExportVo(item));
            }
            return voList;
        } catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("导出异常，请联系网站管理员！");
        }
    }

    @Override
    public List<OrderCommodityExportVo> exportCommodityOrder(String beginTime, String endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date beginDate = sdf.parse(beginTime);
            Date endDate = sdf.parse(endTime);
            List<CommodityOrderExportDao> list = performancesMapper.exportCommodityOrder(beginDate,endDate);
            List<OrderCommodityExportVo> voList = new ArrayList();
            for (CommodityOrderExportDao item :list){
                voList.add(OrderCommodityExportVo.getNew().copyCommodityOrderExportVo(item));
            }
            return voList;
        } catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("导出Excel失败，请联系网站管理员！");
        }
    }
}
