package com.liquidnet.service.sweet.dto.param.admin;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.time.DateUtils;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * SweetIntegralActivityFromParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */

@Data
@ApiModel(value = "SweetIntegralActivityFromParam", description = "积分活动创建活动入参")
public class SweetIntegralActivityFromParam implements Serializable, Cloneable {

    private static final long serialVersionUID = -648510827144997014L;

    @ApiModelProperty(value = "活动id[创建不传] 编辑必须要传", example = "429803743878963206506461")
    private String integralActivityId;

    @ApiModelProperty(required = true, value = "活动名称", example = "大转盘抽奖")
    @NotBlank(message = "activityTitle不能为空")
    private String activityTitle;

    @ApiModelProperty(required = true, value = "活动图片", example = "test.png")
    @NotBlank(message = "activityImg不能为空")
    private String activityImg;

    @ApiModelProperty(required = true, value = "活动类型 1转盘", example = "1")
    @NotNull(message = "activityType不能为空")
    private Integer activityType;

    @ApiModelProperty(required = true, value = "活动时间类型 1长期 2开始结束时间", example = "1")
    @NotNull(message = "timeType不能为空") @Min(value = 1, message = "timeType无效") @Max(value = 2, message = "timeType无效")
    private Integer timeType;

    @ApiModelProperty(value = "如果活动有时间限制 开始时间", example = "2021-01-01 23:20:20")
    private String startTime;

    @ApiModelProperty(value = "如果活动有时间限制 结束时间", example = "2021-01-01 23:20:20")
    private String endTime;

    @ApiModelProperty(required = true, value = "快递费用类型 1包邮 2到付", example = "2")
    @NotNull(message = "expressFeeType不能为空") @Min(value = 1, message = "expressFeeType无效") @Max(value = 2, message = "expressFeeType无效")
    private Integer expressFeeType;

    @ApiModelProperty(required = true, value = "活动规则", example = "这里是活动规则")
    @NotBlank(message = "activityTitle不能为空")
    private String activityRules;

    @ApiModelProperty(required = true, value = "是否上线 1未上线 2已上线", example = "2")
    @NotNull(message = "isOnline不能为空") @Min(value = 1, message = "isOnline无效") @Max(value = 2, message = "isOnline无效")
    private Integer isOnline;

    @Valid
    @ApiModelProperty(value = "奖品列表", example = "")
    @NotNull(message = "prizeList不能为空")
    private List<SweetIntegralActivityPrizeFormParam> prizeList;

    private static final SweetIntegralActivityFromParam obj = new SweetIntegralActivityFromParam();

    public static SweetIntegralActivityFromParam getNew() {
        try {
            return (SweetIntegralActivityFromParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityFromParam();
        }
    }

    public SweetIntegralActivity copy(SweetIntegralActivityFromParam source) {
        SweetIntegralActivity sweetIntegralActivity = SweetIntegralActivity.getNew();
        if (null == source) return null;
        sweetIntegralActivity.setIntegralActivityId(source.getIntegralActivityId());
        sweetIntegralActivity.setActivityTitle(source.getActivityTitle());
        sweetIntegralActivity.setActivityImg(source.getActivityImg());
        sweetIntegralActivity.setActivityType(source.getActivityType());
        sweetIntegralActivity.setTimeType(source.getTimeType());
        if (null != source.getStartTime() && !source.getStartTime().isEmpty()) {
            LocalDateTime startTime = DateUtil.Formatter.yyyyMMddHHmmss.parse(source.getStartTime());
            sweetIntegralActivity.setStartTime(startTime);
        }
        if (null != source.getEndTime() && !source.getEndTime().isEmpty()) {
            LocalDateTime endTime = DateUtil.Formatter.yyyyMMddHHmmss.parse(source.getEndTime());
            sweetIntegralActivity.setEndTime(endTime);
        }
        sweetIntegralActivity.setExpressFeeType(source.getExpressFeeType());
        sweetIntegralActivity.setActivityRules(source.getActivityRules());
        sweetIntegralActivity.setIsOnline(source.getIsOnline());
        return sweetIntegralActivity;
    }

}