package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NonNull;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberPriceParam", description = "添加/编辑会员价格")
@Data
public class AdamMemberPriceParam implements Serializable {
    private static final long serialVersionUID = -6432796310264973696L;
    @ApiModelProperty(position = 1, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 2, value = "会员类型ID", example = "1")
    @NotBlank(message = "会员类型ID不能为空")
    private String memberId;
    @ApiModelProperty(position = 3, value = "状态:0-不可用,1-上线中,2-已下线", allowableValues = "0,1,2")
    @NotNull(message = "状态不能为空")
    @Min(value = 1, message = "状态无效")
    @Max(value = 2, message = "状态无效")
    private Integer state;
    @ApiModelProperty(position = 4, value = "会员价格包名称", example = "年卡")
    @Size(min = 1, max = 30, message = "会员价格包名称长度限制1-30位")
    private String name;
    @ApiModelProperty(position = 5, value = "原价", example = "199")
    @DecimalMin(value = "0.01", message = "原价有误")
    private BigDecimal price;
    @ApiModelProperty(position = 6, value = "折扣价", example = "199")
    @DecimalMin(value = "0.01", message = "折扣价有误")
    private BigDecimal priceFixed;
    @ApiModelProperty(position = 7, value = "有效天数", example = "365")
    @NotNull(message = "有效天数不能为空")
    @Min(value = 30, message = "有效天数不得少于30天")
    private Integer days;
    @ApiModelProperty(position = 8, value = "会员包须知", example = "会员包须知")
    private String detail;
}
