package com.liquidnet.service.sweet.dto.vo;

import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class IntegralActivityPrizeVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -303399210433737206L;

    @ApiModelProperty(value = "奖品id")
    private String prizeId;

    @ApiModelProperty(value = "关联活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品描述")
    private String prizeDescribe;

    @ApiModelProperty(value = "初始展示奖品图片")
    private String prizeImgInit;

    @ApiModelProperty(value = "中奖选中奖品图片")
    private String prizeImgSelect;

    @ApiModelProperty(value = "奖品类型 1积分 2优惠券 3实物 4登登登VIP")
    private Integer prizeType;

    @ApiModelProperty(value = "单次奖励数量如积分 中奖给多少物")
    private Integer prizeTypeNum;

    @ApiModelProperty(value = "奖品数量")
    private Integer prizeNum;

    @ApiModelProperty(value = "中奖概率")
    private BigDecimal winningProbability;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "券列表")
    private List<IntegralActivityPrizeRelationVo> prizeRelationList;

    private static final IntegralActivityPrizeVo obj = new IntegralActivityPrizeVo();
    public static IntegralActivityPrizeVo getNew() {
        try {
            return (IntegralActivityPrizeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityPrizeVo();
        }
    }

    public IntegralActivityPrizeVo copy(SweetIntegralActivityPrize source) {
        if (null == this) return this;
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeId(source.getPrizeId());
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeDescribe(source.getPrizeDescribe());
        this.setPrizeImgInit(source.getPrizeImgInit());
        this.setPrizeImgSelect(source.getPrizeImgSelect());
        this.setPrizeType(source.getPrizeType());
        this.setPrizeTypeNum(source.getPrizeTypeNum());
        this.setPrizeNum(source.getPrizeNum());
        this.setWinningProbability(source.getWinningProbability());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
