package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Data
public class PerformanceAdminListParam {
    @ApiModelProperty(value = "演出名称", example = "")
    private String title;
    @ApiModelProperty(value = "-2全部状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退", example = "-2")
    @NotNull(message = "不能为空")
    private Integer status;
    @ApiModelProperty(value = "城市名称", example = "")
    private String cityName;
    @ApiModelProperty(value = "-2全部,0审核中，2审核拒绝", example = "0")
    @NotNull(message = "不能为空")
    private Integer auditStatus;
    @ApiModelProperty(value = "停售时间（天）-2全部", example = "-2")
    private long stopSellDay;
    @ApiModelProperty(value = "停售时间", example = "2000-01-01 12:00:00", hidden = true)
    private String stopSellTime;
    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "不能为空")
    private Integer pageSize;
    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "不能为空")
    private Integer pageNum;
    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;
    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

    public void setStopSellDay(Long stopSellDay) {
        this.stopSellDay = stopSellDay;
        LocalDateTime now = LocalDateTime.now();
        this.stopSellTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(now.plusDays(-stopSellDay));
    }

    @ApiModelProperty(hidden = true)
    private Integer page;
    @ApiModelProperty(hidden = true)
    private Integer size;

    public void setPageNum(Integer pageNum){
        this.pageNum=pageNum;
        this.page=pageNum;
    }

    public void setPageSize(Integer pageSize){
        this.pageSize=pageSize;
        this.size=pageSize;
    }
}
