package com.liquidnet.service.sweet.config;

import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.PostConstruct;

@Configuration
public class WechatMpConfigure {
    private static String appidZhengzai;
    private static String secretZhengzai;

    @Value("${liquidnet.wechat.service.zhengzai.appid}")
    public void setAppidZhengzai(String appidZhengzai) {
        WechatMpConfigure.appidZhengzai = appidZhengzai;
    }

    @Value("${liquidnet.wechat.service.zhengzai.secret}")
    public void setSecretZhengzai(String secretZhengzai) {
        WechatMpConfigure.secretZhengzai = secretZhengzai;
    }

    private WxMpService wxMpZhengzaiService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @PostConstruct
    public void init() {
        wxMpZhengzaiService = new WxMpServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMpRedisConfigImpl wxMpDefaultConfig = new WxMpRedisConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:service:zhengzai");

//                WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMpDefaultConfig.setAppId(appidZhengzai);
                wxMpDefaultConfig.setSecret(secretZhengzai);

                this.setWxMpConfigStorage(wxMpDefaultConfig);
            }
        };
    }

    public WxMpService getWxMpService() {
        return wxMpZhengzaiService;
    }
}
