package com.liquidnet.client.admin.web.controller.zhengzai.smile;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.framework.web.domain.server.Sys;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVPParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVPSParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVSParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVTSParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersProjectService;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersService;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersTeamService;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.dto.vo.SmileProjectDetailsVo;
import com.liquidnet.service.goblin.dto.vo.SmileVolunteersDetailsVo;
import com.liquidnet.service.goblin.dto.vo.SmileVolunteersTeamVo;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Api(tags = "志愿者")
@Controller
@RequestMapping("/smile/volunteers")
public class SmileVolunteersController extends BaseController {

    @Autowired
    ISmileVolunteersProjectService volunteersProjectService;
    @Autowired
    ISmileVolunteersTeamService volunteersTeamService;
    @Autowired
    ISmileVolunteersService volunteersService;
    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    private final String prefix = "zhengzai/smile/volunteers";

    /**
     * 组列表
     */
    @GetMapping("/team")
    public String listTeam() {
        return prefix + "/team/list";
    }

    /**
     * 活动列表
     */
    @GetMapping("/project")
    public String listProject() {
        return prefix + "/project/list";
    }

    /**
     * 志愿者列表
     */
    @GetMapping()
    public String list() {
        return prefix + "/list";
    }

    /**
     * 新增组
     */
    @GetMapping("/team/add")
    public String addTeam() {
        return prefix + "/team/add";
    }

    /**
     * 新增活动
     */
    @GetMapping("/project/add")
    public String addProject(ModelMap mmap) {
        SmileVTSParam param = new SmileVTSParam();
        param.setPageNum(1);
        param.setPageSize(40);
        List<SmileVolunteersTeam> list = volunteersTeamService.list(param);
        mmap.put("platformUrl", platformUrl);
        mmap.put("listData", list);
        return prefix + "/project/add";
    }


    @PostMapping("team/list")
    @ApiOperation("职责组列表")
    @ResponseBody
    public TableDataInfo listTeam(SmileVTSParam param) {
        PageHelper.startPage(param.getPageNum(), param.getPageSize());
        return getDataTable(volunteersTeamService.list(param));
    }

    @PostMapping("team/insert")
    @ApiOperation("添加职责组")
    @ResponseBody
    public AjaxResult insertTeam(SmileVolunteersTeam bean) {
        return volunteersTeamService.insertData(bean);
    }

    @PostMapping("team/update")
    @ApiOperation("修改职责组")
    @ResponseBody
    public AjaxResult upDateTeam(SmileVolunteersTeam bean) {
        return volunteersTeamService.updateData(bean);
    }

    @GetMapping("team/details/{teamId}")
    @ApiOperation("修改职责组")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "teamId", value = "组id"),
    })
    public String detailsTeam(@PathVariable("teamId") String teamId, ModelMap mmap) {
        SmileVolunteersTeam data = volunteersTeamService.details(teamId);
        mmap.put("smileVolunteersTeam", data);
        return prefix + "/team/edit";
    }

    @GetMapping("team/search")
    @ApiOperation("组名字搜索")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "title", value = "组名称")
    })
    public AjaxResult search(@RequestParam(value = "title", required = false) String title) {
        return volunteersTeamService.search(title);
    }

    @GetMapping("team/ByProjectId")
    @ApiOperation("根据活动id查询关联组")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "projectId", value = "活动id"),
    })
    public AjaxResult getListByProjectId(@RequestParam(value = "projectId", required = false) String projectId) {
        return volunteersTeamService.getListByProjectId(projectId);
    }


    @PostMapping("project/list")
    @ApiOperation("活动列表")
    @ResponseBody
    public TableDataInfo listProject(SmileVPSParam param) {
        PageHelper.startPage(param.getPageNum(), param.getPageSize());
        return getDataTable(volunteersProjectService.list(param));
    }

    @PostMapping("project/insert")
    @ApiOperation("活动新增")
    @ResponseBody
    public AjaxResult insertProject(SmileVPParam param) {
        return volunteersProjectService.insertData(param);
    }

    @PostMapping("project/update")
    @ApiOperation("活动修改")
    @ResponseBody
    public AjaxResult updateProject(SmileVPParam param) {
        return volunteersProjectService.updateData(param);
    }

    @GetMapping("project/details/{projectId}")
    @ApiOperation("活动详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "projectId", value = "活动id"),
    })
    public String detailsProject(@PathVariable("projectId") String projectId, ModelMap mmap) {
        SmileProjectDetailsVo data = volunteersProjectService.details(projectId);
        SmileVTSParam param = new SmileVTSParam();
        param.setPageNum(1);
        param.setPageSize(40);
        List<SmileVolunteersTeamVo> listVo = new ArrayList<>();
        List<SmileVolunteersTeam> listBean = volunteersTeamService.list(param);
        List<String> list = data.getTeamArray().stream().map(SmileVolunteersTeam::getTeamId).collect(Collectors.toList());
        for (SmileVolunteersTeam bean : listBean) {
            SmileVolunteersTeamVo vo = SmileVolunteersTeamVo.getNew();
            vo.setTeamId(bean.getTeamId());
            vo.setName(bean.getName());
            vo.setIntroduce(bean.getIntroduce());
            if (list.contains(bean.getTeamId())) {
                vo.setIsCheck(1);
            } else {
                vo.setIsCheck(0);
            }
            listVo.add(vo);
        }
        data.setTeamVoArray(listVo);
        mmap.put("platformUrl", platformUrl);
        mmap.put("smileProjectDetailsVo", data);
        return prefix + "/project/edit";
    }

    @PostMapping("/list")
    @ApiOperation("志愿者列表")
    @ResponseBody
    public TableDataInfo listVolunteers(SmileVSParam param) {
        PageHelper.startPage(param.getPageNum(), param.getPageSize());
        return getDataTable(volunteersService.list(param));
    }

    @GetMapping("/details/{mid}")
    @ApiOperation("志愿者详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mid", value = "mid"),
    })
    public String detailsVolunteers(@PathVariable("mid")String mid, ModelMap mmap) {
        SmileVolunteersDetailsVo data = volunteersService.details(mid);
        mmap.put("smileVolunteersDetailsVo", data);
        AjaxResult ajaxResult = volunteersTeamService.getListByProjectId(data.getProjectId());
        List<SmileVolunteersTeam> list = ((List<SmileVolunteersTeam>) ajaxResult.get("value"));
        mmap.put("listData", list);
        return prefix + "/edit";
    }

    @PostMapping("/audit")
    @ApiOperation("志愿者审核")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "projectId", value = "活动id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "用户id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "teamId", value = "被分配组id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "审核状态[0-待审核|1-审核通过|2-审核未通过]"),
    })
    public AjaxResult auditVolunteers(String projectId, String uid, String teamId, Integer status) {
        return volunteersService.audit(projectId, uid, teamId, status);
    }
}
