package com.liquidnet.client.admin.zhengzai.smile.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVPParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileVPSParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileVolunteersProjectService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.dto.vo.SmileProjectDetailsVo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.smile.entity.SmileProjectTeamRelation;
import com.liquidnet.service.smile.entity.SmileVolunteersProject;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import com.liquidnet.service.smile.mapper.SmileProjectTeamRelationMapper;
import com.liquidnet.service.smile.mapper.SmileVolunteersProjectMapper;
import com.liquidnet.service.smile.mapper.SmileVolunteersTeamMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Slf4j
@Service
public class SmileVolunteersProjectServiceImpl extends ServiceImpl<SmileVolunteersProjectMapper, SmileVolunteersProject> implements ISmileVolunteersProjectService {

    @Autowired
    SmileVolunteersProjectMapper volunteersProjectMapper;
    @Autowired
    SmileProjectTeamRelationMapper projectTeamRelationMapper;
    @Autowired
    SmileVolunteersTeamMapper volunteersTeamMapper;
    @Autowired
    SmileRedisUtils redisUtils;

    @Override
    public List<SmileVolunteersProject> list(SmileVPSParam param) {
        try {
            TableDataInfo rspData = new TableDataInfo();
            LambdaQueryWrapper<SmileVolunteersProject> wrappers = Wrappers.lambdaQuery(SmileVolunteersProject.class);
            if (param.getTitle() != null && !param.getTitle().equals("")) {
                wrappers.like(SmileVolunteersProject::getTitle, param.getTitle());
            }
            wrappers.orderByDesc(SmileVolunteersProject::getCreatedAt);
            List<SmileVolunteersProject> data = volunteersProjectMapper.selectList(wrappers);
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AjaxResult insertData(SmileVPParam param) {
        LambdaQueryWrapper<SmileVolunteersProject> wrappers = Wrappers.lambdaQuery(SmileVolunteersProject.class);
        wrappers.eq(SmileVolunteersProject::getTitle, param.getTitle());
        List<SmileVolunteersProject> dataList = volunteersProjectMapper.selectList(wrappers);
        if (dataList.size() > 0) {
            return AjaxResult.error("活动名称重复");
        }
        param.setProjectId(IDGenerator.nextTimeId2());
        LocalDateTime now = LocalDateTime.now();
        List<SmileVolunteersTeam> teamList = new ArrayList<>();
        SmileVolunteersProject data = copySmileVolunteersProject(param, now, null);
        int count = volunteersProjectMapper.insert(data);
        for (String teamId : param.getTeamIdArray().split(",")) {
            SmileProjectTeamRelation smileProjectTeamRelation = SmileProjectTeamRelation.getNew();
            smileProjectTeamRelation.setProjectId(param.getProjectId());
            smileProjectTeamRelation.setTeamId(teamId);
            smileProjectTeamRelation.setCreatedAt(now);
            SmileVolunteersTeam volunteersTeam = SmileVolunteersTeam.getNew();
            volunteersTeam.setTeamId(teamId);
            teamList.add(volunteersTeam);
            projectTeamRelationMapper.insert(smileProjectTeamRelation);
        }
        if (count > 0) {
            redisUtils.setProject(param.getProjectId(), SmileProjectDetailsVo.getNew().copy(data, teamList));
            redisUtils.addProjectId(param.getProjectId());
            return AjaxResult.success("添加成功");
        }
        return AjaxResult.error("添加失败");
    }

    @Override
    public AjaxResult updateData(SmileVPParam param) {
        LocalDateTime now = LocalDateTime.now();
        List<SmileVolunteersTeam> teamList = new ArrayList<>();
        LambdaQueryWrapper<SmileVolunteersProject> wrappers = Wrappers.lambdaQuery(SmileVolunteersProject.class);
        wrappers.eq(SmileVolunteersProject::getTitle, param.getTitle());
        List<SmileVolunteersProject> dataList = volunteersProjectMapper.selectList(wrappers);
        for (SmileVolunteersProject data : dataList) {
            if (!data.getProjectId().equals(param.getProjectId()) && data.getTitle().equals(param.getTitle())) {
                return AjaxResult.error("项目名称重复不可修改");
            }
        }
        SmileVolunteersProject data = copySmileVolunteersProject(param, null, now);
        int count = volunteersProjectMapper.update(data, Wrappers.lambdaQuery(SmileVolunteersProject.class).eq(SmileVolunteersProject::getProjectId, param.getProjectId()));
        //删除所有关联关系
        projectTeamRelationMapper.delete(Wrappers.lambdaQuery(SmileProjectTeamRelation.class).eq(SmileProjectTeamRelation::getProjectId, param.getProjectId()));
        for (String teamId : param.getTeamIdArray().split(",")) {
            SmileProjectTeamRelation smileProjectTeamRelation = SmileProjectTeamRelation.getNew();
            smileProjectTeamRelation.setProjectId(param.getProjectId());
            smileProjectTeamRelation.setTeamId(teamId);
            smileProjectTeamRelation.setCreatedAt(now);
            SmileVolunteersTeam volunteersTeam = SmileVolunteersTeam.getNew();
            volunteersTeam.setTeamId(teamId);
            teamList.add(volunteersTeam);
            projectTeamRelationMapper.insert(smileProjectTeamRelation);
        }
        if (count > 0) {
            redisUtils.setProject(param.getProjectId(), SmileProjectDetailsVo.getNew().copy(data, teamList));
            return AjaxResult.success("修改成功");
        }
        return AjaxResult.error("修改失败");
    }

    @Override
    public SmileProjectDetailsVo details(String projectId) {
        LambdaQueryWrapper<SmileVolunteersProject> wrappers = Wrappers.lambdaQuery(SmileVolunteersProject.class);
        wrappers.eq(SmileVolunteersProject::getProjectId, projectId);
        SmileVolunteersProject data = volunteersProjectMapper.selectOne(wrappers);
        //获取 活动 组 关系
        List<String> teamIdList = projectTeamRelationMapper.selectList(Wrappers.lambdaQuery(SmileProjectTeamRelation.class).eq(SmileProjectTeamRelation::getProjectId, projectId)).stream().map(SmileProjectTeamRelation::getTeamId).collect(Collectors.toList());
        //获取 关联组详情
        List<SmileVolunteersTeam> smileVolunteersTeamList = volunteersTeamMapper.selectList(Wrappers.lambdaQuery(SmileVolunteersTeam.class).in(SmileVolunteersTeam::getTeamId, teamIdList));
        //构建返回数据
        return SmileProjectDetailsVo.getNew().copy(data, smileVolunteersTeamList);
    }

    private SmileVolunteersProject copySmileVolunteersProject(SmileVPParam source, LocalDateTime ct, LocalDateTime ut) {
        SmileVolunteersProject smileVolunteersProject = SmileVolunteersProject.getNew();
        smileVolunteersProject.setProjectId(source.getProjectId());
        smileVolunteersProject.setTitle(source.getTitle());
        smileVolunteersProject.setTimeStart(LocalDateTime.parse(source.getTimeStart(), DTF_YMD_HMS));
        smileVolunteersProject.setTimeEnd(LocalDateTime.parse(source.getTimeEnd(), DTF_YMD_HMS));
        smileVolunteersProject.setAddress(source.getAddress());
        smileVolunteersProject.setIntroduce(source.getIntroduce());
        smileVolunteersProject.setImg(source.getImg());
        if (ct != null) {
            smileVolunteersProject.setCreatedAt(ct);
        }
        if (ut != null) {
            smileVolunteersProject.setUpdatedAt(ut);
        }
        return smileVolunteersProject;
    }
}
