package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.WechatTokenInfoVo;
import com.liquidnet.service.sweet.dto.vo.WechatUserInfoVo;
import com.liquidnet.service.sweet.service.impl.SweetWechatLoginServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "小程序-公众号登陆相关")
@RestController
@RequestMapping("/wechatLogin")
@Slf4j
public class SweetWechatLoginController {

    @Autowired
    private SweetWechatLoginServiceImpl sweetLoginService;

    @GetMapping("userInfo")
    @ApiOperation("code获取用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "encryptedData", value = "encryptedData", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "iv", value = "iv", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk 4正在"),
    })
    public ResponseDto userInfo(
            @RequestParam() String code,
            @RequestParam() String encryptedData,
            @RequestParam() String iv,
            @RequestParam(defaultValue = "1") Integer type
    ) {
        return sweetLoginService.userInfo(code, encryptedData, iv, type);
    }

    @ApiOperation(value = "微信小程序登录凭证校验 获取openid", notes = "这里仅用于获取OPENID使用")
    @GetMapping(value = {"maOpenId"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "jsCode", value = "微信jsCode", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk 4正在", required = true)
    })
    public ResponseDto<String> wxaCode2Session(@RequestParam String jsCode, @RequestParam Integer type) {
        return sweetLoginService.wxaCode2Session(jsCode, type);
    }

    @ApiOperation(value = "微信公众号登录 获取openid", notes = "这里仅用于获取OPENID使用")
    @GetMapping(value = {"mpOpenId"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1正在 2摩登", required = true)
    })
    public ResponseDto<String> wxOauth2AccessToken(@RequestParam String code, @RequestParam Integer type) {
        return sweetLoginService.wxOauth2AccessToken(code, type);
    }

    @ApiOperation(value = "微信公众号登录 获取openId、unionId", notes = "本接口在scope参数为snsapi_base时不再提供unionID字段，只需将scope参数修改为snsapi_userinfo即可重新获得用户unionID")
    @GetMapping(value = {"mpAccessTokenInfo"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1正在 2摩登", required = true)
    })
    public ResponseDto<WechatTokenInfoVo> mpWxOauth2AccessTokenInfo(@RequestParam String code, @RequestParam Integer type) {
        return sweetLoginService.mpWxOauth2AccessTokenInfo(code, type);
    }

    @ApiOperation(value = "微信公众号登录 获取用户基本信息", notes = "本接口在用户未关注公众号时，将不返回用户unionID信息，已关注的用户，开发者可使用“获取用户基本信息接口”获取unionID，未关注用户，开发者可使用“微信授权登录接口”并将scope参数设置为snsapi_userinfo，获取用户unionID")
    @GetMapping(value = {"mpUserInfo"})
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1正在 2摩登", required = true)
    })
    public ResponseDto<WechatUserInfoVo> mpUserInfo(@RequestParam String code, @RequestParam Integer type) {
        return sweetLoginService.mpUserInfo(code, type);
    }

}
