/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.SecretException;
import com.taobao.api.internal.util.Base64;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.security.SecretContext;
import com.taobao.api.security.SecretData;
import com.taobao.api.security.SecurityConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityBiz
implements SecurityConstants {
    private static final Map<String, Character> SEPARATOR_CHAR_MAP = new HashMap<String, Character>();
    private static final Map<String, String> SEPARATOR_MAP = new HashMap<String, String>();

    public static Map<String, Character> getSeparatorCharMap() {
        return SEPARATOR_CHAR_MAP;
    }

    public static Map<String, String> getSeparatorMap() {
        return SEPARATOR_MAP;
    }

    public static boolean isEncryptData(String data, String type) throws SecretException {
        if (StringUtils.isEmpty(data) || data.length() < 4) {
            return false;
        }
        Character charValue = SEPARATOR_CHAR_MAP.get(type);
        if (charValue == null) {
            throw new SecretException("type error");
        }
        char separatorChar = charValue.charValue();
        if (data.charAt(0) != separatorChar || data.charAt(data.length() - 1) != separatorChar) {
            return false;
        }
        if (separatorChar == '$') {
            String[] dataArray = StringUtils.split(data, charValue.charValue());
            if (dataArray.length != 3) {
                return false;
            }
            if (data.charAt(data.length() - 2) == separatorChar) {
                return SecurityBiz.checkEncryptData(dataArray);
            }
            String version = dataArray[dataArray.length - 1];
            if (StringUtils.isNumeric(version)) {
                boolean isBase64Value = Base64.isBase64Value(dataArray[dataArray.length - 2]);
                return isBase64Value;
            }
        } else {
            String[] dataArray = StringUtils.split(data, charValue.charValue());
            if (data.charAt(data.length() - 2) == separatorChar) {
                if (dataArray.length != 3) {
                    return false;
                }
                return SecurityBiz.checkEncryptData(dataArray);
            }
            if (dataArray.length != 2) {
                return false;
            }
            return SecurityBiz.checkEncryptData(dataArray);
        }
        return false;
    }

    private static boolean checkEncryptData(String[] dataArray) {
        boolean isBase64Value;
        String version = dataArray[dataArray.length - 1];
        if (StringUtils.isNumeric(version) && (isBase64Value = Base64.isBase64Value(dataArray[0]))) {
            if (dataArray.length == 3) {
                isBase64Value = Base64.isBase64Value(dataArray[1]);
                if (isBase64Value) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static String encryptPhone(String data, String separator, SecretContext secretContext) throws SecretException {
        if (data.length() < 11) {
            return data;
        }
        String prefixNumber = data.substring(0, data.length() - 8);
        String last8Number = data.substring(data.length() - 8);
        return separator + prefixNumber + separator + TaobaoUtils.aesEncrypt(last8Number, secretContext.getSecret()) + separator + secretContext.getSecretVersion() + separator;
    }

    public static String encryptPhoneIndex(String data, String separator, SecretContext secretContext) throws SecretException {
        if (data.length() < 11) {
            return data;
        }
        String last4Number = data.substring(data.length() - 4);
        return separator + TaobaoUtils.hmacMD5EncryptToBase64(last4Number, secretContext.getSecret()) + separator + TaobaoUtils.aesEncrypt(data, secretContext.getSecret()) + separator + secretContext.getSecretVersion() + separator + separator;
    }

    public static String searchPhoneIndex(String data, String separator, SecretContext secretContext) throws SecretException {
        if (data.length() != 4) {
            throw new SecretException("phoneNumber error");
        }
        return separator + TaobaoUtils.hmacMD5EncryptToBase64(data, secretContext.getSecret()) + separator;
    }

    public static String encryptNormal(String data, String separator, SecretContext secretContext) throws SecretException {
        return separator + TaobaoUtils.aesEncrypt(data, secretContext.getSecret()) + separator + secretContext.getSecretVersion() + separator;
    }

    public static String encryptNormalIndex(String data, int compressLen, int slideSize, String separator, SecretContext secretContext) throws SecretException {
        List<String> slideList = TaobaoUtils.getSlideWindows(data, slideSize);
        StringBuilder builder = new StringBuilder();
        for (String slide : slideList) {
            builder.append(TaobaoUtils.hmacMD5EncryptToBase64(slide, secretContext.getSecret(), compressLen));
        }
        return separator + TaobaoUtils.aesEncrypt(data, secretContext.getSecret()) + separator + builder.toString() + separator + secretContext.getSecretVersion() + separator + separator;
    }

    public static String searchNormalIndex(String data, int compressLen, int slideSize, SecretContext secretContext) throws SecretException {
        List<String> slideList = TaobaoUtils.getSlideWindows(data, slideSize);
        StringBuilder builder = new StringBuilder();
        for (String slide : slideList) {
            builder.append(TaobaoUtils.hmacMD5EncryptToBase64(slide, secretContext.getSecret(), compressLen));
        }
        return builder.toString();
    }

    public static SecretData getSecretData(String data, char separatorChar) {
        SecretData secretData = null;
        if ('$' == separatorChar) {
            String[] dataArray = StringUtils.split(data, separatorChar);
            if (dataArray.length != 3) {
                return null;
            }
            String version = dataArray[2];
            if (StringUtils.isNumeric(version)) {
                secretData = new SecretData();
                secretData.setOriginalValue(dataArray[0]);
                secretData.setOriginalBase64Value(dataArray[1]);
                secretData.setSecretVersion(Long.valueOf(version));
            }
        } else {
            String[] dataArray = StringUtils.split(data, separatorChar);
            if (dataArray.length != 2) {
                return null;
            }
            String version = dataArray[1];
            if (StringUtils.isNumeric(version)) {
                secretData = new SecretData();
                secretData.setOriginalBase64Value(dataArray[0]);
                secretData.setSecretVersion(Long.valueOf(version));
            }
        }
        return secretData;
    }

    public static SecretData getIndexSecretData(String data, char separatorChar) {
        SecretData secretData = null;
        if ('$' == separatorChar) {
            String[] dataArray = StringUtils.split(data, separatorChar);
            if (dataArray.length != 3) {
                return null;
            }
            String version = dataArray[2];
            if (StringUtils.isNumeric(version)) {
                secretData = new SecretData();
                secretData.setOriginalValue(dataArray[0]);
                secretData.setOriginalBase64Value(dataArray[1]);
                secretData.setSecretVersion(Long.valueOf(version));
            }
        } else {
            String[] dataArray = StringUtils.split(data, separatorChar);
            if (dataArray.length != 3) {
                return null;
            }
            String version = dataArray[2];
            if (StringUtils.isNumeric(version)) {
                secretData = new SecretData();
                secretData.setOriginalBase64Value(dataArray[0]);
                secretData.setOriginalValue(dataArray[1]);
                secretData.setSecretVersion(Long.valueOf(version));
            }
        }
        if (secretData == null) {
            return secretData;
        }
        secretData.setSearch(true);
        return secretData;
    }

    static {
        SEPARATOR_CHAR_MAP.put("nick", Character.valueOf('~'));
        SEPARATOR_CHAR_MAP.put("receiver_name", Character.valueOf('~'));
        SEPARATOR_CHAR_MAP.put("normal", Character.valueOf('\u0001'));
        SEPARATOR_CHAR_MAP.put("phone", Character.valueOf('$'));
        SEPARATOR_CHAR_MAP.put("simple", Character.valueOf('~'));
        SEPARATOR_CHAR_MAP.put("search", Character.valueOf('~'));
        SEPARATOR_MAP.put("nick", SIMPLE_SEPARATOR);
        SEPARATOR_MAP.put("receiver_name", SIMPLE_SEPARATOR);
        SEPARATOR_MAP.put("normal", NORMAL_SEPARATOR);
        SEPARATOR_MAP.put("phone", PHONE_SEPARATOR);
        SEPARATOR_MAP.put("simple", SIMPLE_SEPARATOR);
        SEPARATOR_MAP.put("search", SIMPLE_SEPARATOR);
    }
}

