package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.service.consumer.kylin.receiver.ConsumerKylinOrderRefundExpressRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.KylinQueue.SQL_ORDER_REFUND_EXPRESS;


@Configuration
public class ConsumerKylinOrderRefundExpressRedisStreamConfig {
    @Autowired
    ConsumerKylinOrderRefundExpressRdsReceiver consumerKylinOrderRefundExpressRdsReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 用户退款发快递
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveSqlOrderRefundExpress(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(SQL_ORDER_REFUND_EXPRESS.getGroup(), SQL_ORDER_REFUND_EXPRESS.name() + t),
                StreamOffset.create(SQL_ORDER_REFUND_EXPRESS.getKey(), ReadOffset.lastConsumed()), consumerKylinOrderRefundExpressRdsReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    @Bean
    public Subscription subscriptionOrderRefundExpress(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOrderRefundExpress(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionOrderRefundExpress2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOrderRefundExpress(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionOrderRefundExpress3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlOrderRefundExpress(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}