package com.liquidnet.service.order.test;

import com.alibaba.fastjson.JSON;
import com.liquidnet.service.base.codec.util.CodecUtil;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.Base64Utils;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: CodecTest
 * @Package com.liquidnet.service.order.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/6 12:29
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class CodecTest {
    @Test
    public void testEncrypt(){
        System.out.println("CodecUtil.AES_SECRET_KEY_BYTES=== "+ Base64Utils.encodeToString(CodecUtil.AES_SECRET_KEY_BYTES));

        System.out.println(CodecUtil.sha1Encrypt("this is a test"));
        long timestamp = System.currentTimeMillis();
        System.out.println("时间戳：" + timestamp);
//        UserLoginReq userLoginReq = new UserLoginReq("admin", "admin");
//        String data = JSON.toJSONString(userLoginReq);
//        String data = "{\"number\":1,\"ticketId\":\"2811887059054592999181\",\"isElectronic\":1,\"isExpress\":0,\"deviceFrom\":\"wap\",\"actual\":0.01,\"performanceId\":\"2811713813327872196937\",\"timeId\":\"2811766812553216086853\",\"returnUrl\":\"http://testm.zhengzai.tv/#/order/status?order_type=ticket&order_id=\",\"showUrl\":\"http://testm.zhengzai.tv/#/order/status?order_type=ticket&order_id=\",\"expressType\":2,\"agentId\":0,\"payType\":\"alipay\"}";
        String data = "{\"number\":1,\"ticketId\":\"11316\",\"isElectronic\":1,\"isExpress\":0,\"deviceFrom\":\"wap\",\"actual\":220,\"performanceId\":\"5936371\",\"timeId\":\"126207700372889606864872\",\"returnUrl\":\"http://172.16.2.120:8080/#/pay/status?order_type=ticket&order_id=\",\"showUrl\":\"http://172.16.2.120:8080/#/pay/status?order_type=ticket&order_id=\",\"expressType\":1,\"agentId\":0,\"payType\":\"wepay\"}";
        System.out.println("加密前的数据：" + data);
        String encryptedData = CodecUtil.aesEncrypt(data);
        System.out.println("加密后的数据：" + encryptedData);
        String sign = CodecUtil.sha1Encrypt(encryptedData + timestamp);
        System.out.println("签名：" + sign);
        EncryptedReq<PayOrderParam> encryptedReq = new EncryptedReq<>();
        encryptedReq.setEncryptedData(encryptedData);
        encryptedReq.setTimestamp(timestamp);
        encryptedReq.setSign(sign);
        System.out.println("加密后的请求：" + JSON.toJSONString(encryptedReq));
    }
}

//CodecUtil.AES_SECRET_KEY_BYTES=== XjjkaLnlzAFbR399IP4kdQ==
//        f52666839c984e5720a06a9ca4673dd12e8f4ffa
//        时间戳：1627622460314
//        加密前的数据：{"number":1,"ticketId":"11316","isElectronic":1,"isExpress":0,"deviceFrom":"wap","actual":220,"performanceId":"5936371","timeId":"126207700372889606864872","returnUrl":"http://172.16.2.120:8080/#/pay/status?order_type=ticket&order_id=","showUrl":"http://172.16.2.120:8080/#/pay/status?order_type=ticket&order_id=","expressType":1,"agentId":0,"payType":"wepay"}
//        加密后的数据：HGGFm1DHHYnRZHgvB25eSEneEFPRCvNcrheFlSTGRRLVzY4QscH4v1TmzJ5MXzhIfh3iYsBj/NEfZ7ynNZ2qO8QeOTxBLjVJSxU3NZNArsz52BpMmbF70GlGT5b++0QszHvDo9lNTMHNWLqh8711tdYxLbtFMMKTSpJcvzJOiyCmA3d5vLdkNvZ9IjkTrjoDQ3KEYCumGUue6n4CmA6VRqSvc4HnD6A4tkzyhgOR5o0pLJduvnkuGSqtsdZpkBnXpos91xTfNNUm7i1tiYPZXA0EVn7OfFfh+zEEfyQx/Nfn3SNQ079abatubI4Yko4NoP7FgG2i5J6JVB6UgpWqeMcKHACDlxQmadTdQ9eR4qCjKlf38MoNuAIfdwLCSHPeMRjgl2WeQAqCmOR/+L7V8pGDYZR+6oFgBjl6zx3HANJsMhpNsUPKYO9qO1iqdGsMuq7ZYlXlNy1txroij5usZcLHwD/bmOXKO/X07yV559g=
//        签名：4465b794fe277545cfcd37cdbf7dbecae491213f
//        加密后的请求：{"encryptedData":"HGGFm1DHHYnRZHgvB25eSEneEFPRCvNcrheFlSTGRRLVzY4QscH4v1TmzJ5MXzhIfh3iYsBj/NEfZ7ynNZ2qO8QeOTxBLjVJSxU3NZNArsz52BpMmbF70GlGT5b++0QszHvDo9lNTMHNWLqh8711tdYxLbtFMMKTSpJcvzJOiyCmA3d5vLdkNvZ9IjkTrjoDQ3KEYCumGUue6n4CmA6VRqSvc4HnD6A4tkzyhgOR5o0pLJduvnkuGSqtsdZpkBnXpos91xTfNNUm7i1tiYPZXA0EVn7OfFfh+zEEfyQx/Nfn3SNQ079abatubI4Yko4NoP7FgG2i5J6JVB6UgpWqeMcKHACDlxQmadTdQ9eR4qCjKlf38MoNuAIfdwLCSHPeMRjgl2WeQAqCmOR/+L7V8pGDYZR+6oFgBjl6zx3HANJsMhpNsUPKYO9qO1iqdGsMuq7ZYlXlNy1txroij5usZcLHwD/bmOXKO/X07yV559g=","sign":"4465b794fe277545cfcd37cdbf7dbecae491213f","timestamp":1627622460314}

