package com.liquidnet.service.galaxy;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestRedisUtil
 * @Package com.liquidnet.service.galaxy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 16:26
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestRedisUtil {
    @Autowired
    private RedisDataSourceUtil redisUtil;

    private long keyExpireTime = 3600*24*30;


    @Test
    public void testSet(){
        String userId = "test123";
        GalaxyUserInfoBo userInfoBo = GalaxyUserInfoBo.getNew();
        userInfoBo.setUserId(userId);

        String key = GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode()).concat(":") + userId;
        redisUtil.getRedisGalaxyUtil().set(key,userInfoBo,keyExpireTime);
    }
}
