package com.liquidnet.service.galaxy.dto.vo.mongo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftOrderBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 11:16
 */
@Data
public class GalaxyNftTradeVo implements Serializable,Cloneable {
    /**
     * 应用系统购买系列唯一ID
     */
    private String nftId;
    /**
     * nft名字
     */
    private String nftName;
    /**
     * 本地系列唯一名称
     */
    private String seriesName;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 本地系列唯一编码
     */
    private String seriesCode;
    /**
     * nftId
     */
    private String tradeHash;
    /**
     * nft价格
     */
    private String chainTimestamp;

    /**
     * 转出方地址
     */
    private String fromAddress;

    /**
     * 转入方地址
     */
    private String toAddress;

    /**
     * nft发行任务ID
     */
    private Long tradePrice;

    /**
     * nft购买任务id
     * @return
     */
    private String tradeType;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;
    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTradeVo obj = new GalaxyNftTradeVo();

    public static GalaxyNftTradeVo getNew() {
        try {
            return (GalaxyNftTradeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTradeVo();
        }
    }
}
