package com.liquidnet.service.sweet.vo;

import com.liquidnet.service.sweet.entity.SweetCollectionReservation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetCollectionReservationVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -6689305045906446522L;

    @ApiModelProperty("reservation_id")
    private String reservationId;

    @ApiModelProperty("union_id")
    private String unionId;

    @ApiModelProperty("称呼")
    private String nickname;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("邮箱")
    private String mailbox;

    @ApiModelProperty("企业名称")
    private String enterpriseName;

    @ApiModelProperty("职务")
    private String title;

    @ApiModelProperty("创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty("更新时间")
    private LocalDateTime updatedAt;

    @ApiModelProperty("活动状态 1正常 2已结束")
    private Integer status;

    private static final SweetCollectionReservationVo obj = new SweetCollectionReservationVo();
    public static SweetCollectionReservationVo getNew() {
        try {
            return (SweetCollectionReservationVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetCollectionReservationVo();
        }
    }

    public SweetCollectionReservationVo copy(SweetCollectionReservation source) {
        if (null == source) return this;
        this.setReservationId(source.getReservationId());
        this.setUnionId(source.getUnionId());
        this.setNickname(source.getNickname());
        this.setMobile(source.getMobile());
        this.setMailbox(source.getMailbox());
        this.setEnterpriseName(source.getEnterpriseName());
        this.setTitle(source.getTitle());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
