package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.entity.SweetCollectionReservation;
import com.liquidnet.service.sweet.mapper.SweetCollectionReservationMapper;
import com.liquidnet.service.sweet.service.ISweetCollectionReservationService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisActivityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;

/**
 * <p>
 * 数字藏品预约活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-18
 */
@Service
public class SweetCollectionReservationServiceImpl extends ServiceImpl<SweetCollectionReservationMapper, SweetCollectionReservation> implements ISweetCollectionReservationService {

    @Autowired
    private RedisActivityUtils activityUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<Integer> info() {
        LocalDateTime endTime = activityUtils.getEndTime("reservation");
        LocalDateTime nowTime = LocalDateTime.now();
        if (null == endTime || nowTime.isAfter(endTime)) {
            return ResponseDto.success(2);
        } else {
            return ResponseDto.success(1);
        }
    }

    @Override
    public ResponseDto<Boolean> time(String endTime) {
        activityUtils.setEndTime("reservation", endTime);
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> create(String nickname, String mobile, String mailbox, String enterpriseName, String title) {
        SweetCollectionReservation reservation = SweetCollectionReservation.getNew();
        String id = IDGenerator.nextSnowId();
        LocalDateTime nowTime = LocalDateTime.now();
        reservation.setReservationId(id);
        reservation.setNickname(nickname);
        reservation.setMobile(mobile);
        reservation.setMailbox(mailbox);
        reservation.setEnterpriseName(enterpriseName);
        reservation.setTitle(title);
        reservation.setCreatedAt(nowTime);
        reservation.setUpdatedAt(nowTime);


        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_collection_reservation.insert"));
        sqlsDataA.add(new Object[]{
                id, nickname, mobile, mailbox, enterpriseName, title, nowTime, nowTime
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANSWER_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        return ResponseDto.success();
    }
}
