package com.liquidnet.client.admin.zhengzai.smile.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.goblin.dto.vo.SmileSellDataVO;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

@Component
public class SmileRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;


    /**
     * redis保存用户
     */
    public void setSmileUserVO(String uid, SmileUserVO smileUserVO){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SMILE_USER.concat(uid), smileUserVO);
    }

    /**
     * redis获取SmileUserVO
     */
    public SmileUserVO getSmileUserVO(String uid){
       return (SmileUserVO)redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SMILE_USER.concat(uid));
    }

    /**
     * 根据学校id获取学校名称
     */
    public String getSchoolNameById(String schoolId){
        return (String) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId));
    }

    /**
     * 保存/更新学校
     */
    public void setSchool(String schoolId, String schoolName){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId), schoolName);
    }

    /**
     * 保存全部学校
     */
    public void setSchoolAll(List<SmileSchoolVo> smileSchoolVos){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SMILE_SCHOOL,smileSchoolVos);
    }

    /**
     * 删除学校
     */
    public void delSchool(String schoolId){
        redisDataSourceUtil.getRedisSweetUtil().del(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId));
    }

    /**
     * 获取演出打款状态
     */
    public String getShowStatus(String performancesId){
       return (String) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SMILE_SHOW.concat(performancesId));
    }

    /**
     * 保存演出ids
     */
    public void setShowIds(String perId){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SMILE_SHOW, perId);
    }

    /**
     * 保存个人打款
     */
    public void setPriceByUid(String performancesId,String uid){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(":").concat(uid),0);
    }

    /**
     * 获取个人打款状态
     */
    public Integer getShowPriceUid(String performancesId,String uid){
        return (Integer) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(":").concat(uid));
    }

    /**
     * 删除个人打款状态
     */
    public void delPriceByUid(String performancesId,String uid){
        redisDataSourceUtil.getRedisSweetUtil().del(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(":").concat(uid));
    }

    /**
     * 总共演出打款
     */
    public void setShowPriceId(String performancesId){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId),0);
    }

    /**
     * 总共演出打款删除
     */
    public void delShowPriceId(String performancesId){
        redisDataSourceUtil.getRedisSweetUtil().del(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId));
    }

    /**
     *获取演出打款状态
     */
    public Integer getShowPriceId(String performancesId){
        return (Integer) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId));
    }

    /**
     * 获取用户数据
     */
    public SmileSellDataVO getSellDataVO(String uid, String performancesId){
        return (SmileSellDataVO) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_DATA.concat(uid).concat(performancesId));
    }

    /**
     * 保存票提
     */
    public void setAgent(String performancesId,String ticketId, SmileAgentVo smileAgentVo){
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SMILE_AGENT.concat(performancesId).concat(":").concat(ticketId), smileAgentVo);
    }

    public BigDecimal getUserTotalPrice(String uid) {
       return new BigDecimal((redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_USER_REVENUE.concat(uid)))==null ? "0":(String) (redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_USER_REVENUE.concat(uid))));
    }

    public void setUserTotalPrice(String uid, String add) {
        redisDataSourceUtil.getRedisSweetUtil().set(SmileRedisConst.SELL_USER_REVENUE.concat(uid),add);
    }


    /*public Boolean set(String key, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().set(key, value);
    }

    public Object get(String key){
        return redisDataSourceUtil.getRedisSweetUtil().get(key);
    }

    public void del(String s) {
        redisDataSourceUtil.getRedisSweetUtil().del(s);
    }

    public boolean hset(String key, String item, Object value){
        return redisDataSourceUtil.getRedisAdamUtil().hset(key,item,value);
    }

    public boolean lSet(String key, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().lSet(key,value);
    }

    public boolean lSet(String key, List<Object> value){
        return redisDataSourceUtil.getRedisSweetUtil().lSet(key,value);
    }

    public  List<Object> lGet(String key, long start, long end) {
        return redisDataSourceUtil.getRedisSweetUtil().lGet(key, start, end);
    }

    public long lGetListSize(String key) {
        return redisDataSourceUtil.getRedisSweetUtil().lGetListSize(key);
    }

    public Object lGetIndex(String key, long index) {
        return redisDataSourceUtil.getRedisSweetUtil().lGetIndex(key,index);
    }

    public long lRemove(String key, long count, Object value){
        return redisDataSourceUtil.getRedisSweetUtil().lRemove(key, count, value);
    }

    public boolean hasKey(String key) {
        return redisDataSourceUtil.getRedisSweetUtil().hasKey(key);
    }*/
}
