package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单单品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderSku implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单sku_id
     */
    private String orderSkuId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 商品图
     */
    private String spuPic;

    /**
     * 款式id
     */
    private String skuId;

    /**
     * 状态 同order
     */
    private Integer status;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 款式原价
     */
    private BigDecimal skuPrice;

    /**
     * 款式实付价
     */
    private BigDecimal skuPriceActual;

    /**
     * 退款价格
     */
    private BigDecimal priceRefund;

    /**
     * 款式名称
     */
    private String skuName;

    /**
     * 款式编号
     */
    private String skuNo;

    /**
     * 款式图片
     */
    private String skuImage;

    /**
     * 款式规格
     */
    private String skuSpecs;

    /**
     * 管理员优惠价格
     */
    private BigDecimal priceModify;

    /**
     * 款式最终优惠价
     */
    private BigDecimal priceVoucher;

    /**
     * 单品的分拥比例 0 表示不分佣金
     */
    private BigDecimal commissionRate;

    /**
     * 单品的分拥比例 0 表示不分佣金
     */
    private BigDecimal sCommissionRate;

    /**
     * 分类扣率
     */
    private BigDecimal cateRate;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinOrderSku obj = new GoblinOrderSku();

    public static GoblinOrderSku getNew() {
        try {
            return (GoblinOrderSku) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderSku();
        }
    }
}
