package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinSelfTagVo", description = "平台标签库")
@Data
public class GoblinSelfTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 972558538207500034L;
    @ApiModelProperty(position = 10, value = "标签ID")
    private String tagId;
    @ApiModelProperty(position = 11, value = "标签名称")
    private String tagName;
    @ApiModelProperty(position = 12, value = "标签描述")
    private String tagDesc;
    @ApiModelProperty(position = 13, value = "标签图片")
    private String tagPic;
    @ApiModelProperty(position = 14, value = "标签类型[1-音乐人|2-艺术家|3-IP]")
    private String tagType;
    @ApiModelProperty(position = 15, value = "标签所属[0-普通标签|1-专属标签]")
    private String tagBelong;
    @ApiModelProperty(position = 16, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;

    private static final GoblinSelfTagVo obj = new GoblinSelfTagVo();

    public static GoblinSelfTagVo getNew() {
        try {
            return (GoblinSelfTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinSelfTagVo();
        }
    }

    public GoblinSelfTagVo copy(GoblinSelfTag source) {
        if (null == source) return this;
        this.setTagId(source.getTagId());
        this.setTagName(source.getTagName());
        this.setTagDesc(source.getTagDesc());
        this.setTagPic(source.getTagPic());
        this.setTagType(source.getTagType());
        this.setTagBelong(source.getTagBelong());
        this.setDelFlg(source.getDelFlg());
        return this;
    }
}
