package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo;
import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;

import java.util.List;

public interface IGoblinStoreMgtExtraService {
    /**
     * 平台分类列表
     *
     * @return List<GoblinSelfGoodsCategoryVo>
     */
    List<GoblinSelfGoodsCategoryVo> listCategoryVo();

    /**
     * 平台标签列表
     *
     * @param keyword 标签名称匹配关键字
     * @param belong  标签所属[0-普通标签|1-专属标签]
     * @return List<GoblinSelfTagVo>
     */
    List<GoblinSelfTagVo> listTagVo(String keyword, String belong);

    /**
     * 服务支持列表
     *
     * @return List<GoblinServiceSupportVo>
     */
    List<GoblinServiceSupportVo> listServiceSupportVo();
}
