package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * NFT订单表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrder implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 款式id
     */
    private String skuId;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 商铺名称
     */
    private String storeName;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户昵称
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 应付金额
     */
    private BigDecimal priceTotal;

    /**
     * 券优惠金额
     */
    private BigDecimal priceCoupon;

    /**
     * 商铺券优惠金额
     */
    private BigDecimal storePriceCoupon;

    /**
     * 红包优惠金额
     */
    private BigDecimal priceRedEnvelope;

    /**
     * 总优惠价格
     */
    private BigDecimal priceVoucher;

    /**
     * 实付金额
     */
    private BigDecimal priceActual;

    /**
     * 券id
     */
    private String ucouponId;

    /**
     * 商铺券id
     */
    private String storeCouponId;

    /**
     * 红包code
     */
    private String redEnvelopeCode;

    /**
     * 订单状态 1待付款 2已付款 3未付款取消订单 4退款中 5已退款
     */
    private Integer status;

    /**
     * 订单来源 app|h5|applet
     */
    private String source;

    /**
     * 订单类型 1购买订单 2兑换订单 3演出赠送订单
     */
    private Integer orderType;

    /**
     * 支付类型 wepay微信 alipay阿里 douyinpay抖音 unionpay银联
     */
    private String payType;

    /**
     * 支付终端 app wap js applet
     */
    private String deviceFrom;

    /**
     * 版本号
     */
    private String version;

    /**
     * 订单过期时间(分钟)
     */
    private Integer payCountdownMinute;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 支付单号
     */
    private String payCode;

    /**
     * 支付中心返回实际支付类型
     */
    private String paymentType;

    /**
     * 支付中心返回支付id
     */
    private String paymentId;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 取消时间
     */
    private LocalDateTime cancelTime;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final GoblinNftOrder obj = new GoblinNftOrder();

    public static GoblinNftOrder getNew() {
        try {
            return (GoblinNftOrder) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrder();
        }
    }


}
