package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * NFT订单退款表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrderRefund implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单退单表id
     */
    private String orderRefundId;

    /**
     * 退款单号
     */
    private String refundCode;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 商铺id
     */
    private String storeId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 退款金额
     */
    private BigDecimal price;

    /**
     * 退款状态 1申请|2退款成功|3退款失败
     */
    private Integer status;

    /**
     * 退款时间
     */
    private LocalDateTime refundAt;

    /**
     * 退款失败原因
     */
    private String errorReason;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final GoblinNftOrderRefund obj = new GoblinNftOrderRefund();

    public static GoblinNftOrderRefund getNew() {
        try {
            return (GoblinNftOrderRefund) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderRefund();
        }
    }


}
