package com.liquidnet.service.sweet.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetPerformanceShowParam implements Serializable,Cloneable{
    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 主键id
     */
    private String arId;

    private String performanceId;
    /**
     * 演出名
     */
    private String performanceName;
    /**
     * 图片地址1
     */
    private String picOne;
    /**
     * 图片地址2
     */
    private String picTwo;
    /**
     * AR地址
     */
    private String arUrl;
    /**
     * 离线地址
     */
    private String offlineUrl;

    /**
     * 状态 1可用 0不可用
     */
    private Integer status;
    /**
     * 开始时间
     */
    private String timeStart;
    /**
     * 结束时间
     */
    private String timeEnd;

    private static final SweetPerformanceShowParam obj = new SweetPerformanceShowParam();
    public static SweetPerformanceShowParam getNew() {
        try {
            return (SweetPerformanceShowParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetPerformanceShowParam();
        }
    }
}
