package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.mapper.SweetPerformanceMapper;
import com.liquidnet.service.sweet.service.ISweetPerformanceAppService;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Service
public class SweetPerformanceAppServiceImpl extends ServiceImpl<SweetPerformanceMapper, SweetPerformanceShow> implements ISweetPerformanceAppService {
    @Autowired
    private RedisDataUtils redisUtils;

    @Override
    public ResponseDto<PageInfo<SweetPerformanceShow>> getlistInTime(Integer page, Integer size) {
        PageInfo<SweetPerformanceShow> pageInfo = null;
        try {
            List<SweetPerformanceShow> data = new ArrayList<>();
            PageHelper.startPage(page, size);
            LocalDateTime time = LocalDateTime.now();
            List<SweetPerformanceShow> performanceARList = redisUtils.getPerformanceAR();
            for (SweetPerformanceShow performanceShow : performanceARList) {
                if (time.isBefore(performanceShow.getTimeEnd()) && time.isAfter(performanceShow.getTimeStart()) && performanceShow.getStatus() == 1) {
                    data.add(performanceShow);
                }
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }

    }
}
