package com.liquidnet.client.admin.web.controller.zhengzai.smile;

import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmilePriceParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.TakeByPerId;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author TT
 */
@Api(tags = "演出管理")
@RestController
@RequestMapping("/smile/show")
public class SmileShowController {

    @Autowired
    ISmileShowService smileShowService;

    @PostMapping("/list")
    @ApiOperation("演出列表")
    @ResponseBody
    public TableDataInfo schoolList(SmileShowParam smileShowParam) {
        return smileShowService.listShow(smileShowParam);
    }

    @GetMapping("/getShowById")
    @ApiOperation("根据演出id查询演出详情")
    public AjaxResult getShowById(String performancesId) {
        return smileShowService.getShowById(performancesId);
    }

    @PostMapping("/sort")
    @ApiOperation("演出排序")
    public AjaxResult sort(@RequestBody ShowSort showSort) {
        return smileShowService.sort(showSort);
    }


    @PutMapping("/upTakeByPerId")
    @ApiOperation("演出上下架[1：下架，0：上架]")
    public AjaxResult upTakeByPerId(@RequestBody TakeByPerId takeByPerId) {
        return smileShowService.upTakeByPerId(takeByPerId.getPerId(), takeByPerId.getType());
    }

    @PostMapping("/price")
    @ApiOperation("个人打款打款")
    public AjaxResult price(@RequestBody SmilePriceParam smilePriceParam) {
        return smileShowService.price(smilePriceParam);
    }

    @PostMapping("/allPrice")
    @ApiOperation("演出标识打款")
    public AjaxResult allPrice(@RequestBody SmilePriceParam smilePriceParam) {
        return smileShowService.allPrice(smilePriceParam);
    }

    @GetMapping("/updateRedis")
    @ApiOperation("修改原保存演出id的数据类型,分支dev_0507kids  部署完执行接口（演出列表重复问题修复也可以运行此接口）")
    public AjaxResult updateRedis() {
        return smileShowService.updateRedis();
    }

}
