package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;

@ApiModel(value = "AdamMemberParam", description = "添加会员参数")
@Data
public class AdamMemberParam implements Serializable {
    private static final long serialVersionUID = 5940725094369061032L;

    /**
     * 会员卡id
     */
    @ApiModelProperty(position = 0, required = false, value = "会员ID[50]")
    private String memberId;

    /**
     * 会员卡名称
     */
    @ApiModelProperty(position = 1, required = false, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;

    /**
     * 标题
     */
    @ApiModelProperty(position = 2, required = false, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;

    /**
     * 副标题
     */
    @ApiModelProperty(position = 3, required = false, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;

    /**
     * 图标
     */
    @ApiModelProperty(position = 4, required = false, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;

    /**
     * 头像
     */
    @ApiModelProperty(position = 5, required = false, value = "会员头像[200]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.pngv")
    private String avatar;

    /**
     * 权益详情
     */
    private String interestsDetail;

    /**
     * 注意事项
     */
    private String notes;

    /**
     * '是否展示须知'
     */
    private Integer isNotice;

    /**
     * 须知内容
     */
    private String noticeInfo;

    /**
     * 须知标题
     */
    private String noticeTitle;

    /**
     * 是否需要答题 0不需要 1需要
     */
    private Integer needQuestion;

    /**
     * 是否展示协议 0否1是
     */
    private Integer displayAgreement;

    /**
     * 会员协议
     */
    private String agreement;

    /**
     * 限购数量
     */
    private Integer limitation;
}
