package com.liquidnet.service.example.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.adam.api.FeignAdamBaseClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "example")
@RestController
@RequestMapping("emp")
public class ExampleController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FeignAdamBaseClient feignAdamBaseClient;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "Simple test")
    @GetMapping(value = "test")
    public ResponseEntity<?> test(String str) {
        log.info("This is `service-example` api.test: {}", str);
        return ResponseEntity.ok("This is `service-example` api.test: " + str);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "Curl test for `adam`")
    @GetMapping(value = {"adam/api"})
    public ResponseDto<?> testAdamApi() {
        ResponseDto<?> responseDto = null;
        try {
            responseDto = feignAdamBaseClient.queryAddresses("227342162880225289951928", "227025591620198404948759");
            log.info("Curl test for feignAdamBaseClient.queryAddresses():{}", responseDto.toJson());
        } catch (Exception e) {
            log.error("Curl test for `adam` exception", e);
        }
        return responseDto;
    }
}
