package com.liquidnet.service.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.SmileVolunteersApplyParam;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.goblin.service.manage.SmileVolunteersService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import com.liquidnet.service.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
@Slf4j
public class SmileVolunteerServerImpl implements SmileVolunteersService {
    @Autowired
    private SmileRedisUtils smileRedisUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    Utils utils;

    @Override
    public ResponseDto<List<SmileVProjectListVo>> projectList(String uid) {
        List<SmileVProjectListVo> voList = ObjectUtil.smileVProjectListVoList();
        List<String> projectIds = smileRedisUtils.getProjectId();
        for (String projectId : projectIds) {
            SmileProjectDetailsVo redisData = smileRedisUtils.getProject(projectId);
            ArrayList<String> teamIds = smileRedisUtils.getVolunteers(projectId, uid);
            SmileVProjectListVo vo = SmileVProjectListVo.getNew().copy(redisData, teamIds == null ? 0 : 1);
//            if (LocalDateTime.now().isBefore(LocalDateTime.parse(vo.getTimeEnd(), DTF_YMD_HMS))) {
            voList.add(vo);
//            }
        }
        voList = voList.stream().sorted(Comparator.comparing(SmileVProjectListVo::getTimeStart)).collect(Collectors.toList());
        return ResponseDto.success(voList);
    }

    @Override
    public ResponseDto<SmileVProjectVo> projectDetails(String uid, String projectId) {
        List<SmileVTeamVo> teamVos = ObjectUtil.smileVTeamVoList();
        SmileProjectDetailsVo redisData = smileRedisUtils.getProject(projectId);
        ArrayList<String> teamIds = smileRedisUtils.getVolunteers(projectId, uid);
        List<SmileVolunteersTeam> beanList = redisData.getTeamArray();
        if (beanList != null) {
            List<String> projectTeamR = beanList.stream().map(SmileVolunteersTeam::getTeamId).collect(Collectors.toList());
            for (String teamId : projectTeamR) {
                SmileVolunteersTeam bean = smileRedisUtils.getTeam(teamId);
                int checkStatus = 0;
                if (teamIds != null) {
                    checkStatus = teamIds.contains(teamId) ? 1 : 0;
                }
                SmileVTeamVo teamVo = SmileVTeamVo.getNew().copy(bean, checkStatus);
                teamVos.add(teamVo);
            }
        }
        Integer applyStatus = teamIds == null ? 0 : 1;
        SmileVProjectVo vo = SmileVProjectVo.getNew().copy(redisData, applyStatus, teamVos);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> apply(SmileVolunteersApplyParam param) {
        String uid = CurrentUtil.getCurrentUid();
        ArrayList<String> teamIds = CollectionUtil.arrayListString();
        try {
            if (smileRedisUtils.getVolunteers(param.getProjectId(), uid) != null) {
                return ResponseDto.failure("该账号已经报名");
            }
            if (smileRedisUtils.getProjectIdCard(param.getProjectId(), param.getIdCard()) != null) {
                return ResponseDto.failure("该证件已经报名");
            }

            if (!utils.validate(param.getName(), param.getIdCard())) {
                return ResponseDto.failure("验证身份证失败！");
            }

            smileRedisUtils.setProjectIdCard(param.getProjectId(), param.getIdCard());

            if (!param.getTeamId1().equals("") && param.getTeamId1() != null) {
                teamIds.add(param.getTeamId1());
            }
            if (!param.getTeamId2().equals("") && param.getTeamId2() != null) {
                teamIds.add(param.getTeamId2());
            }
            if (!param.getTeamId3().equals("") && param.getTeamId3() != null) {
                teamIds.add(param.getTeamId3());
            }
            smileRedisUtils.setVolunteers(param.getProjectId(), uid, teamIds);
            queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(),
                    SqlMapping.get("smile_volunteers.apply",
                            uid, param.getProjectId(), param.getName(), param.getImg(),
                            param.getIdCard(), param.getSex(), param.getSchool(), param.getSchoolAddress(),
                            param.getSpecialty(), param.getSpecialty2(), param.getPhone(), param.getTeamId1(),
                            param.getTeamId2(), param.getTeamId3(), param.getIntroduce(), LocalDateTime.now()
                    ));
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }
}
