package com.liquidnet.service.sweet.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.third.shumei.util.ShumeiUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;

import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import static com.liquidnet.service.sweet.constant.SweetConstant.REDIS_KEY_SWEET_WECHAT_MAODENG_OPEN_POSTER;

@Service
public class SweetTestImpl {
    @Autowired
    private ShumeiUtil shumeiUtil;
    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private RedisUtil redisUtil;

    /**
     * 文字
     */
    public ResponseDto insertToText(String fromUser,String maoContent){
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setTextMsg(maoContent);

        String maoId = IDGenerator.nextSnowId();
        //敏感词判断
        //此处判断不需要用户登录，所以使用时间代替
        String currentUid = DateUtil.now().getTime()+"";
        if (!shumeiUtil.checkText(currentUid, maoContent)) {
            //文字敏感 提示，发送文本消息
            return ResponseDto.failure("文字非法");
        }
        if(maoContent.equals("猫登天空")){
            redisUtils.setSweetMaoDengOpen(fromUser,10*60);
            return null;
        }
        String i = redisUtils.getSweetMaoDengOpen(fromUser);

        //是否参加了活动
        if (StringUtil.isNotEmpty(i)) {

            SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDengTransfer(fromUser);
            /*String maoIdText =null;
            if (sweetMaoDeng != null){
                maoIdText= sweetMaoDeng.getMaoId();
            }*/

            if (sweetMaoDeng != null) {
                String picUrl = sweetMaoDeng.getPicUrl();
                sweetMaoDengVo.setPicUrl(picUrl);
               /* maoId=sweetMaoDeng.getMaoId();
                sweetMaoDengVo.setMaoId(maoId);
                String s="";
                //更新mysql
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_maodeng.text.update"));
                sqlsDataA.add(new Object[]{maoContent,fromUser,maoId});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));*/
            }/*else {

                sweetMaoDengVo.setMaoId(maoId);
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_maodeng.insert"));
                String s="";
                sqlsDataA.add(new Object[]{maoId, fromUser, maoContent, null,null});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));
            }*/
            //获取过期时间
            long expire = redisUtil.getExpire(REDIS_KEY_SWEET_WECHAT_MAODENG_OPEN_POSTER + fromUser);
            redisUtils.setSweetMaoDengTransfer(sweetMaoDengVo,expire);
        }
        return null;
    }


    /**
     * 图片
     */
    public ResponseDto insertToImg(String fromUser,String picUrl){
        String maoId = IDGenerator.nextSnowId();
        //图片非法判断
        //此处判断不需要用户登录，所以使用时间代替
        String currentUid = DateUtil.now().getTime()+"";
        if (!shumeiUtil.checkImage(currentUid, picUrl)) {
            //图片非法 提示，发送文本消息
            return ResponseDto.failure("非法的图片");
        }
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setPicUrl(picUrl);
        String i = redisUtils.getSweetMaoDengOpen(fromUser);
        if (StringUtil.isNotEmpty(i)){
            //活动已开启  持久化  redis
            //判断是否第一次参加活动
            SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDengTransfer(fromUser);

           /* String maoIdText =null;
            if (sweetMaoDeng != null){
                maoIdText= sweetMaoDeng.getMaoId();
            }*/
            String textMsg =null;
            if (sweetMaoDeng != null){
                textMsg =sweetMaoDeng.getTextMsg();
                sweetMaoDengVo.setTextMsg(textMsg);


              /* String s="";
                //更新mysql
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_wechat_maodeng.img.update"));
                sqlsDataA.add(new Object[]{picUrl,fromUser,maoId});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));*/
            }/*else {
               sweetMaoDengVo.setMaoId(maoId);
              *//* //redis队列入库
               LinkedList<String> sqls = CollectionUtil.linkedListString();
               LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
               sqls.add(SqlMapping.get("sweet_wechat_maodeng.insert"));
               sqlsDataA.add(new Object[]{maoId, fromUser, null, picUrl,null});
               queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));
               String s="";*//*
           }*/
            redisUtils.setSweetMaoDeng(sweetMaoDengVo);

        }
        return null;
    }

}
