package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 人流量排队检测摄像头表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinCamera implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * camera_id
     */
    private String cameraId;

    /**
     * 设备用户名/国标ID
     */
    private String streamName;

    /**
     * 场地ID
     */
    private String fieldId;

    /**
     * 截图url
     */
    private String imgUrl;

    /**
     * 地点类型 1卫生间 2。。。
     */
    private Integer siteType;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
