package com.liquidnet.common.third.zxlnft.config;

import com.liquidnet.commons.lang.util.BASE64Util;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.io.UnsupportedEncodingException;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: EasemobConfig
 * @Package com.liquidnet.common.third.easemob.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/7 10:42
 */
@Configuration
public class ZxlnftConfig {
    @Value("${liquidnet.service.galaxy.zxlnft.appId}")
    private String appId;
    @Value("${liquidnet.service.galaxy.zxlnft.appKey}")
    private String appKey;
    @Value("${liquidnet.service.galaxy.zxlnft.nftPlatformAddress}")
    private String nftPlatformAddress;
    @Value("${liquidnet.service.galaxy.zxlnft.nftPlatformPubKey}")
    private String nftPlatformPubKey;
    @Value("${liquidnet.service.galaxy.zxlnft.nftPlatformPriKey}")
    private String nftPlatformPriKey;
    @Value("${liquidnet.service.galaxy.zxlnft.walletSdkUrl}")
    private String walletSdkUrl;
    @Value("${liquidnet.service.galaxy.zxlnft.nftApiUrl}")
    private String nftApiUrl;

    @Value("${liquidnet.service.galaxy.zxlnft.platformIdentification}")
    private String platformIdentification;

    public String getAppId(){
        return appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getNftPlatformAddress() {
        return nftPlatformAddress;
    }

    public String getPlatformIdentification() {
        return platformIdentification;
    }

    //    public String getNftPlatformPubKey(){
//        return nftPlatformPubKey;
//    }
//
//    public String getNftPlatformPriKey(){
//        return nftPlatformPriKey;
//    }

    public String getNftPlatformPubKey(){
        String pubKey = null;
        try {
            pubKey = BASE64Util.decode(nftPlatformPubKey);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    public String getNftPlatformPriKey(){
        String priKey = null;
        try {
            priKey = BASE64Util.decode(nftPlatformPriKey);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return priKey;
    }

    public String getWalletSdkUrl(){
        return walletSdkUrl;
    }

    public String getNftApiUrl(){
        return nftApiUrl;
    }

}

