package com.liquidnet.common.cache.redisson.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import java.io.IOException;


/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: redisson配置类
 * @class: RedissonConfig
 * @Package com.liquidnet.service
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/11 13:15
 */
//@Configuration
public class RedissonConfig {

    @Bean
    public RedissonClient redisson() throws IOException {
        // 本例子使用的是yaml格式的配置文件，读取使用Config.fromYAML，如果是Json文件，则使用Config.fromJSON
        Config config = Config.fromYAML(RedissonConfig.class.getClassLoader().getResource("application-redisson-config.yml"));
        return Redisson.create(config);
    }
}
