package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分活动表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivity implements Serializable, Cloneable {

    private static final long serialVersionUID = 8170221349064837744L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动id
     */
    private String integralActivityId;

    /**
     * 活动名称
     */
    private String activityTitle;

    /**
     * 活动图片
     */
    private String activityImg;

    /**
     * 活动类型 1转盘
     */
    private Integer activityType;

    /**
     * 活动玩一次所需积分
     */
    private Integer activityNum;

    /**
     * 预估玩此活动的总人数
     */
    private Integer estimatedNum;

    /**
     * 活动时间类型 1长期 2开始结束时间
     */
    private Integer timeType;

    /**
     * 如果活动有时间限制 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 如果活动有时间限制 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 快递费用类型 1包邮 2到付
     */
    private Integer expressFeeType;

    /**
     * 活动规则
     */
    private String activityRules;

    /**
     * 概率公示
     */
    private String probabilityPublicity;

    /**
     * 是否上线 1未上线 2已上线
     */
    private Integer isOnline;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivity obj = new SweetIntegralActivity();

    public static SweetIntegralActivity getNew() {
        try {
            return (SweetIntegralActivity) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivity();
        }
    }

}
