package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.IKylinPerformancesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-02-25
 */
@Api(tags = "前端-演出其他接口")
@RestController
@RequestMapping("performanceOther")
@Slf4j
public class KylinPerformancesOtherController {

    @Autowired
    private IKylinPerformancesService iKylinPerformancesService;

    @PostMapping("subscribe")
    @ApiOperation("演出预约")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "sourceType", value = "来源 1小程序 2h5", required = true)
    })
    public ResponseDto<String> subscribe(
            @RequestParam() String performancesId,
            @RequestParam() Integer sourceType
    ) {
        return iKylinPerformancesService.subscribe(performancesId, sourceType);
    }

    @GetMapping("isSubscribe")
    @ApiOperation("是否预约演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true)
    })
    public ResponseDto<Integer> isSubscribe(@RequestParam() String performancesId) {
        return iKylinPerformancesService.isSubscribe(performancesId);
    }
}
