package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetAppletServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "小程序-登陆相关")
@RestController
@RequestMapping("/appletLogin")
@Slf4j
public class SweetAppletLoginController {

    @Autowired
    private SweetAppletServiceImpl sweetAppletService;

    @ApiOperation(value = "获取小程序openId")
    @GetMapping("/findCode2openid")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "code", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "type", value = "alipay支付宝,wepay 微信")
    })
    public ResponseDto<String> findCode2openid(@RequestParam String code,@RequestParam String type) {
        return sweetAppletService.findCode2openid(code,type);
    }


}
