package com.liquidnet.service.chime.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.chime.constant.ChimeConstant;
import com.liquidnet.service.chime.dto.ChimeUserDoTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.util.Calendar;

@Slf4j
@Component
public class DoTaskUtils {
    @Autowired
    private RedisUtil redisUtil;
    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;

    /**
     * 划卡调任务
     * @param currentUserId
     */
    public void userAddNum(String currentUserId) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_YEAR,1);
        cal.set(Calendar.HOUR_OF_DAY,0);
        cal.set(Calendar.SECOND,0);
        cal.set(Calendar.MINUTE,0);
        cal.set(Calendar.MILLISECOND,0);
        Long timeout=(cal.getTimeInMillis()-System.currentTimeMillis())/1000;
        Integer i;
        //判断当天是否有划卡
        if (!redisUtil.hasKey(ChimeConstant.REDIS_USER_OPEN_NUM+currentUserId)){
            i=1;
            redisUtil.set(ChimeConstant.REDIS_USER_OPEN_NUM+currentUserId, i, timeout);
        }else {
            i = (Integer) redisUtil.get(ChimeConstant.REDIS_USER_OPEN_NUM+currentUserId)+1;
        }

        redisUtil.set(ChimeConstant.REDIS_USER_OPEN_NUM+currentUserId, i, timeout);
        //获取用户是否调用过任务接口
        boolean hasKey = redisUtil.hasKey(ChimeConstant.REDIS_USER_TO_DOTASK + currentUserId);
        if(!hasKey){

            //满足10次调用接口，每天最多调用一次
            if(i >= 10){
                MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
                params.add("uid", currentUserId);
                params.add("taskId", 3 + "");
                String resultData = HttpUtil.post(stoneUrl + "/user/inner/doTask", params);

                ChimeUserDoTask chimeUserDoTask = JsonUtils.fromJson(resultData, ChimeUserDoTask.class);
                Boolean success = chimeUserDoTask.getSuccess();
                //接口调用失败，重试
                if (!success) {
                    this.userAddNum(currentUserId);
                }else {
                    //调用接口成功,记录
                    redisUtil.set(ChimeConstant.REDIS_USER_TO_DOTASK +currentUserId,1,timeout);
                }
            }
        }
    }
}
