package com.liquidnet.service.kylin.dao;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 演出
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinPerformancesDao implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 演出id
     */
    private String ticketId;

    /**
     * performances_id
     */
    private String performancesId;

    /**
     * 演出名称
     */
    private String title;

    /**
     * 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演
     */
    private Integer type;

    /**
     * 演出海报
     */
    private String imgPoster;

    /**
     * 省id
     */
    private String provinceId;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 城市id
     */
    private Integer cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 县id
     */
    private Integer districtId;

    /**
     * 县名称
     */
    private String districtName;

    /**
     * 批文地址
     */
    private String approvalUrl;

    /**
     * 演出公告
     */
    private String notice;

    /**
     * 主办方id
     */
    private String sponsorId;

    /**
     * 主办方类型
     */
    private String sponsorType;

    /**
     * 主办方
     */
    private String sponsor;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String mobile;

    /**
     * 演出简介
     */
    private String describes;

    /**
     * 演出详情
     */
    private String details;

    /**
     * 购票须知
     */
    private String noticeImage;

    /**
     * 演出开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 演出结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 提审时间
     */
    private LocalDateTime auditTime;

    /**
     * 拒绝理由
     */
    private String rejectTxt;

    /**
     * 权重 高则在上
     */
    private Integer sort;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinPerformancesDao obj = new KylinPerformancesDao();

    public static KylinPerformancesDao getNew() {
        try {
            return (KylinPerformancesDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinPerformancesDao();
        }
    }

    public Object[] insert(KylinPerformancesDao vo) {
        return new Object[]{
                vo.getPerformancesId(),
                vo.getTitle(),
                vo.getType(),
                vo.getImgPoster(),
//                vo.getProvinceId(),
//                vo.getProvinceName(),
                vo.getCityId(),
                vo.getCityName(),
//                vo.getDistrictId(),
//                vo.getDistrictName(),
                vo.getApprovalUrl(),
                vo.getNotice(),
                vo.getSponsorId(),
                vo.getSponsorType(),
                vo.getSponsor(),
                vo.getContacts(),
                vo.getMobile(),
                vo.getDescribes(),
                vo.getDetails(),
                vo.getNoticeImage(),
                vo.getTimeStart(),
                vo.getTimeEnd(),
//                vo.getAuditTime(),
//                vo.getRejectTxt(),
                0,
                vo.getComment(),
                vo.getCreatedAt(),
                vo.getUpdatedAt(),
        };
    }
}
