package com.liquidnet.client.admin.zhengzai.goblin.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.constant.NftAccStatusEnum;
import com.liquidnet.service.goblin.dto.GoblinUserNftAccInfoVo;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class GoblinRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    /**
     * 覆盖店铺活动
     *
     * @param selfMarketId
     * @param data
     */
    public void setSelfMarket(String selfMarketId, GoblinSelfMarketingVo data) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, data);
    }

    /**
     * 删除店铺活动
     *
     * @param selfMarketId
     */
    public void delSelfMarket(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_SELF_MARKET.concat(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().del(redisKey);
    }

    /**
     * 正在下单 可参加商户
     *
     * @param selfMarketId
     * @param data
     */
    public void setZhengzaiRelation(String selfMarketId, GoblinMarketingZhengzaiRelationVo data) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + data.getStoreId());
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, data);
    }

    public void delZhengzaiRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_RELATION.concat(selfMarketId).concat(":store_id:" + storeId);
        redisDataSourceUtil.getRedisGoblinUtil().del(redisKey);
    }

    /**
     * 获取 当前商铺能参与的官方活动id列表
     *
     * @param storeId
     * @return
     */
    public List<String> getZhengzaiRelation(String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        Object obj = redisDataSourceUtil.getRedisGoblinUtil().get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<String>) obj;
        }
    }

    //添加 当前商铺能参与的活动id列表
    public void addStoreSelfRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        List<String> list = getZhengzaiRelation(storeId);
        list.add(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, list);
    }

    //删除 当前商铺能参与的活动id列表
    public void delStoreSelfRelation(String selfMarketId, String storeId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_STORE_SELF_RELATION.concat(storeId);
        List<String> list = getZhengzaiRelation(storeId);
        list.remove(selfMarketId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, list);
    }

    //获取 正在下单 活动列表
    public List<GoblinSelfMarketingVo> getZhengzaiList() {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        Object obj = redisDataSourceUtil.getRedisGoblinUtil().get(redisKey);
        if (obj == null) {
            return new ArrayList();
        } else {
            return (List<GoblinSelfMarketingVo>) obj;
        }
    }

    //添加 正在下单 活动列表
    public void addZhengzaiList(GoblinSelfMarketingVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        List<GoblinSelfMarketingVo> list = getZhengzaiList();
        list.add(vo);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, list);
    }

    //删除 正在下单 活动列表
    public void delZhengzaiList(String selfMarketId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        List<GoblinSelfMarketingVo> list = getZhengzaiList();
        for (GoblinSelfMarketingVo item : list) {
            if (item.getSelfMarketId().equals(selfMarketId)) {
                list.remove(item);
                break;
            }
        }
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, list);
    }

    //修改 正在下单 活动列表
    public void changeZhengzaiList(GoblinSelfMarketingVo vo) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_ZHENGZAI_LIST;
        List<GoblinSelfMarketingVo> list = getZhengzaiList();
        for (int i = 0; i < list.size(); i++) {
            GoblinSelfMarketingVo item = list.get(i);
            if (item.getSelfMarketId().equals(vo.getSelfMarketId())) {
                list.set(i, vo);
                break;
            }
        }
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, list);
    }

    //是否开通数字账号
    public Boolean getIsOpenAccount(String userId) {
        String redisKey = GoblinRedisConst.REDIS_GOBLIN_NFT_NUM_ACCOUNT_INFO.concat(userId);
        Object obj = redisDataSourceUtil.getRedisGoblinUtil().get(redisKey);
        GoblinUserNftAccInfoVo openAccountInfo;
        if (obj == null) {
            openAccountInfo = null;
        } else {
            openAccountInfo = (GoblinUserNftAccInfoVo) obj;
        }
        // 认证验证
        if (null == openAccountInfo || !NftAccStatusEnum.StatusAcc.SUCCESS.getCode().equals(openAccountInfo.getCode())) {
            return false;
        } else {
            return true;
        }
    }

    //获取 当前xx链上SkuId 发行的数量
    public int getNftCountBySku(String skuId) {
        String redisKey = GalaxyConstant.REDIS_KEY_GALAXY_PUBLISH_NFT.concat(":").concat(skuId);
        Object obj = redisDataSourceUtil.getRedisGoblinUtil().get(redisKey);
        if (obj == null) {
            return -1;
        } else {
            return (int) obj;
        }
    }

    //获取 nft序号站位list
    public List<String> getNftList(String skuId) {
        String redisKey = GoblinRedisConst.GOBLIN_NUM_LIST.concat(":").concat(skuId);
        Object obj = redisDataSourceUtil.getRedisGoblinUtil().get(redisKey);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    //添加 nft序号站位list
    public boolean addNftList(String skuId, String num) {
        String redisKey = GoblinRedisConst.GOBLIN_NUM_LIST.concat(":").concat(skuId);
        List<String> voList = getNftList(skuId);
        if (voList.contains(num)) {
            return false;
        }
        voList.add(num);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, voList);
        return true;
    }

    public GoblinGoodsSkuInfoVo getGoodsSkuInfoVo(String skuId) {
        String rk = GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId);
        GoblinGoodsSkuInfoVo vo = (GoblinGoodsSkuInfoVo) redisDataSourceUtil.getRedisGoblinUtil().get(rk);
        if (null == vo ) {
            return null;
        }
        return vo;
    }

    //覆盖 站位宾哥要dto
    public void setNftNumDetails(String num, String skuId, GalaxyNftPublishAndBuyReqDto dto) {
        String redisKey = GoblinRedisConst.GOBLIN_NUM_DETAILS.concat(num).concat(skuId);
        redisDataSourceUtil.getRedisGoblinUtil().set(redisKey, dto);
    }
}
