package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.partner.KylinTicketPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTickets;

import java.util.List;

/**
 * <p>
 * 票 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
public interface IKylinTicketsPartnerService {

    /**
     * 创建票汇总
     * @param ticketCreateParam 相关参数
     * @return vo
     */
    ResponseDto<KylinTicketPartnerVo> createTicketSummary(TicketCreateParam ticketCreateParam);

    /**
     * 未通过审核创建票
     * @param ticketCreateParam 相关参数
     * @return vo
     */
    ResponseDto<KylinTicketPartnerVo> createTicket(TicketCreateParam ticketCreateParam);

    /**
     * 通过审核后创建票
     * @param ticketCreateParam 相关参数
     * @return vo
     */
    ResponseDto<KylinTicketPartnerVo> addNewTicket(TicketCreateParam ticketCreateParam);

    /**
     * 修改票
     * @param ticketCreateParam 相关参数
     * @return vo
     */
    ResponseDto<KylinTicketPartnerVo> updateTicket(TicketCreateParam ticketCreateParam);

    /**
     * 删除 票(只有未审核通过可删除)
     * @param ticketsId 票id
     * @return boolean
     */
    ResponseDto<String> deleteTicket(String ticketsId);

    /**
     * 复制票
     * @param ticketsId 票id
     * @return vo
     */
    ResponseDto<KylinTicketPartnerVo> copyTicket(String performanceId,String ticketsId);

    /**
     * 整个场次票 提交 审核
     * @param timesId 场次id
     * @return boolean
     */
    boolean submitTicketByTimes(String timesId,Integer status);

    /**
     * 从mongo 获取 当前场次所有 票
     * @param timesId 场次id
     * @return list<vo>
     */
    List<KylinTicketPartnerVo> getTicketMongoList(String timesId);

    /**
     * 从mongo 获取 当前票
     * @param ticketsId 票id
     * @return vo
     */
    KylinTicketPartnerVo getTicketsMongo(String ticketsId);

    /**
     * 票上线
     * @param ticketsId 票id
     * @return boolean
     */
    ResponseDto<String> onLine(String ticketsId,String performancesId);

    /**
     * 票下线
     * @param ticketsId 票id
     * @return boolean
     */
    ResponseDto<String> outLine(String ticketsId,String performancesId);
}
