package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 照片
     */
    private String img;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    private Integer sex;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 省key
     */
    private Integer provinceKey;

    /**
     * 省
     */
    private String province;

    /**
     * 市key
     */
    private Integer cityKey;

    /**
     * 市
     */
    private String city;

    /**
     * 区key
     */
    private Integer areaKey;

    /**
     * 区
     */
    private String area;

    /**
     * 详细地址
     */
    private String address;

    /**
     * 微信号
     */
    private String wechat;

    /**
     * 代理类型（1：总代，2：普代）
     */
    private Integer type;

    /**
     * 组织关联
     */
    private Long orgId;

    /**
     * 身份证号
     */
    private Long idCard;

    /**
     * 学校名称
     */
    private String schoolName;

    /**
     * 专业
     */
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    private Integer identity;

    /**
     * 标识步骤
     */
    private Integer tag;

    /**
     * 1：代理开启，2：代理关闭
     */
    private Integer agent;

    /**
     * 自我介绍
     */
    private String introduce;

    /**
     * 擅长1
     */
    private String specialty1;

    /**
     * 擅长2
     */
    private String specialty2;

    /**
     * 擅长3
     */
    private String specialty3;

    /**
     * 正常/黑名单
     */
    private Integer state;

    /**
     * 0：删除，1正常
     */
    private Integer delTag;

    private LocalDateTime createdDate;

    private LocalDateTime updatedDate;


}
