package com.liquidnet.client.admin.zhengzai.slime.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.bean.BeanUtils;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeMongoUtil;
import com.liquidnet.client.admin.zhengzai.slime.utils.SlimeRedisUtil;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.service.slime.dto.param.admin.SlimeFieldEditParam;
import com.liquidnet.service.slime.dto.vo.SlimeCompaniesVo;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsVo;
import com.liquidnet.service.slime.entity.SlimeCompanies;
import com.liquidnet.service.slime.entity.SlimeFields;
import com.liquidnet.service.slime.mapper.SlimeFieldsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class SlimeFieldsAdminServiceImpl extends ServiceImpl<SlimeFieldsMapper, SlimeFields> implements ISlimeFieldsAdminService {

    @Autowired
    SlimeRedisUtil slimeRedisUtil;

    @Autowired
    SlimeMongoUtil slimeMongoUtil;

    @Autowired
    ISlimeCompaniesAdminService slimeCompaniesAdminService;

    @Override
    public boolean fieldEdit(SlimeFieldEditParam parameter) {
        LocalDateTime now = LocalDateTime.now();

        // 查询场地 entity
        LambdaQueryWrapper<SlimeFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFields.class);
        fieldsLambdaQueryWrapper.eq(SlimeFields::getFieldId, parameter.getFieldId());
        SlimeFields fieldsEntity = getOne(fieldsLambdaQueryWrapper);
        if (null == fieldsEntity) {
            throw new LiquidnetServiceException();
        }

        // 场地 entity
        BeanUtils.copyProperties(parameter, fieldsEntity);
        fieldsEntity.setUpdatedAt(now);

        // 场地 mysql
        updateById(fieldsEntity);

        // 场地 vo
        SlimeFieldsVo fieldsVo = SlimeFieldsVo.getNew();
        fieldsVo.copy(fieldsEntity);
        if (null != fieldsVo.getCompanyId() && !fieldsVo.getCompanyId().isEmpty()) {
            LambdaQueryWrapper<SlimeCompanies> companiesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeCompanies.class);
            companiesLambdaQueryWrapper.eq(SlimeCompanies::getCompanyId, fieldsVo.getCompanyId());
            SlimeCompanies companies = slimeCompaniesAdminService.getOne(companiesLambdaQueryWrapper);

            SlimeCompaniesVo companiesVo = SlimeCompaniesVo.getNew();
            companiesVo.copy(companies);
            fieldsVo.setCompaniesVo(companiesVo);
        }

        // 场地 mongo
        slimeMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

        // 场地 redis
        slimeRedisUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);

        return true;
    }
}
