package com.liquidnet.service.platform.controller.goblin.code;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.PageInfoVo;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;
import com.liquidnet.service.goblin.service.IGoblinNftExCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/19 2:53 下午
 */

@Api(tags = "兑换码")
@Slf4j
@Validated
@RestController
@RequestMapping("code")
public class GoblinNftExCodeController {

    @Autowired
    IGoblinNftExCodeService iGoblinNftExCodeService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "根据nft兑换活动获取兑换码")
    @PostMapping("selectCodePageList")
    public ResponseDto<PageInfoVo> selectCodePageList(@RequestBody GoblinNftExCodeParam goblinNftExCodeParam) {
        return ResponseDto.success(iGoblinNftExCodeService.selectCodePageList(goblinNftExCodeParam));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "兑换码主动失效")
    @PostMapping("defDrivLoseCodes/{codeIds}")
    public ResponseDto<Boolean> defDrivLoseCode(@PathVariable("codeIds") String codeIds) {
        return ResponseDto.success(iGoblinNftExCodeService.defDrivLoseCode(codeIds));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "空投发送")
    @PostMapping("addAirdrop")
    public ResponseDto<Boolean> addAirdrop(@RequestBody GoblinNftExCodeParam goblinNftExCodeParam) {
        return iGoblinNftExCodeService.addAirdrop(goblinNftExCodeParam);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "excel空投批量发送")
    @PostMapping("addAirdrops/{activityId}/{adminUid}")
    public ResponseDto<Boolean> addAirdrops(MultipartFile file,@PathVariable("activityId")String activityId,@PathVariable("adminUid") String adminUid) {
        return iGoblinNftExCodeService.addAirdrops(file,activityId,adminUid);
    }


    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "兑换码导出")
    @PostMapping("excel")
    public void excel(HttpServletResponse httpServletResponse, @RequestBody GoblinNftExCodeParam goblinNftExCodeParam) {
        iGoblinNftExCodeService.excel(httpServletResponse, goblinNftExCodeParam);
    }


}
