package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyBaseReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 12:21
 */
@Data
public class GalaxyBaseReqDto implements Serializable,Cloneable{
    /**
     * 路由类型(至信链zxinchain、百度链xuper)
     */
    @ApiModelProperty(position = 1, required = true, value = "路由类型(至信链zxinchain、百度链xuper)")
    @NotBlank(message = "路由类型不能为空！")
    private String routerType = GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode();

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyBaseReqDto obj = new GalaxyBaseReqDto();

    public static GalaxyBaseReqDto getNew() {
        try {
            return (GalaxyBaseReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyBaseReqDto();
        }
    }
}
